/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include "category_info_view.h"
#include <urlglib/ug_i18n.h>

void category_info_view_init (CategoryInfoView *cinfo_view)
{
	GtkWidget* label;
	GtkTable*  top_table;
	GtkTable*  table;
//	GtkWidget* frame;

	// initialize base class : DownloadSettingView
	download_info_view_init (&cinfo_view->dinfo_view);
	download_info_view_set_multiple (&cinfo_view->dinfo_view, TRUE);

	cinfo_view->multiple = FALSE;
	cinfo_view->self = cinfo_view->dinfo_view.self;
	label = gtk_label_new (_("Category Setting"));
	top_table = (GtkTable*)gtk_table_new (3, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (top_table), 2);
	gtk_notebook_prepend_page (GTK_NOTEBOOK (cinfo_view->self), GTK_WIDGET (top_table), label);

	cinfo_view->entry = gtk_entry_new ();
	cinfo_view->label_name = gtk_label_new_with_mnemonic (_("Category _name:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL(cinfo_view->label_name), cinfo_view->entry);
	gtk_table_attach (top_table, cinfo_view->label_name, 0, 1, 0, 1,
	                  GTK_SHRINK, GTK_SHRINK, 2, 2);
	gtk_table_attach (top_table, cinfo_view->entry, 1, 2, 0, 1,
	                  GTK_FILL | GTK_EXPAND, GTK_SHRINK, 2, 2);

	// option table
	table = (GtkTable*) gtk_table_new (3, 2, FALSE);
	gtk_table_attach (top_table, GTK_WIDGET (table), 0, 2, 1, 2,
	                  GTK_FILL, GTK_SHRINK, 0, 2);

	cinfo_view->spin_download = gtk_spin_button_new_with_range (1.0, 9.0, 1.0);
	gtk_entry_set_width_chars (GTK_ENTRY(cinfo_view->spin_download), 4);
	label = gtk_label_new_with_mnemonic (_("Active _downloads:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL(label), cinfo_view->spin_download);
	gtk_table_attach (table, label, 0, 1, 0, 1,
	                  GTK_SHRINK, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->spin_download, 1, 2, 0, 1,
	                  GTK_SHRINK, GTK_SHRINK, 0, 2);

	label = gtk_label_new (_("Capacity of Completed:"));
	cinfo_view->spin_completed = gtk_spin_button_new_with_range (0.0, 9999.0, 1.0);
	gtk_entry_set_width_chars (GTK_ENTRY(cinfo_view->spin_completed), 4);
	gtk_table_attach (table, label, 0, 1, 1, 2,
	                  GTK_SHRINK, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->spin_completed, 1, 2, 1, 2,
	                  GTK_SHRINK, GTK_SHRINK, 0, 2);

	label = gtk_label_new (_("Capacity of Recycled:"));
	cinfo_view->spin_recycled = gtk_spin_button_new_with_range (0.0, 9999.0, 1.0);
	gtk_entry_set_width_chars (GTK_ENTRY(cinfo_view->spin_recycled), 4);
	gtk_table_attach (table, label, 0, 1, 2, 3,
	                  GTK_SHRINK, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->spin_recycled, 1, 2, 2, 3,
	                  GTK_SHRINK, GTK_SHRINK, 0, 2);

/*
	// frame
	frame = gtk_frame_new (NULL);
	table = (GtkTable*) gtk_table_new (6, 3, FALSE);
	gtk_container_add (GTK_CONTAINER (frame), GTK_WIDGET (table));
	gtk_table_attach (top_table, frame, 0, 2, 2, 3,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
	// separator
	gtk_table_attach (table, gtk_vseparator_new (), 1, 2, 0, 6,
	                  GTK_SHRINK, GTK_FILL, 2, 2);

	label = gtk_label_new (_("Visible columns:"));
	cinfo_view->button_col_completed = gtk_check_button_new_with_label (_("Completed"));
	cinfo_view->button_col_total = gtk_check_button_new_with_label (_("Total"));
	cinfo_view->button_col_speed = gtk_check_button_new_with_label (_("Speed"));
	cinfo_view->button_col_retry = gtk_check_button_new_with_label (_("Retry"));
	cinfo_view->button_col_url = gtk_check_button_new_with_label (_("URL"));
	gtk_table_attach (table, label, 0, 1, 0, 1,
	                  GTK_FILL, GTK_SHRINK, 2, 2);
	gtk_table_attach (table, cinfo_view->button_col_completed, 0, 1, 1, 2,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->button_col_total, 0, 1, 2, 3,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->button_col_speed, 0, 1, 3, 4,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->button_col_retry, 0, 1, 4, 5,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->button_col_url, 0, 1, 5, 6,
	                  GTK_FILL, GTK_SHRINK, 0, 2);

	// frame for TextView
	label = gtk_label_new (_("TextArea information:"));
	cinfo_view->button_text_filename = gtk_check_button_new_with_label (_("Filename"));
	cinfo_view->button_text_directory = gtk_check_button_new_with_label (_("Directory"));
	cinfo_view->button_text_url = gtk_check_button_new_with_label (_("URL"));
	cinfo_view->button_text_message = gtk_check_button_new_with_label (_("Message"));
	gtk_table_attach (table, label, 2, 3, 0, 1,
	                  GTK_FILL, GTK_SHRINK, 2, 2);
	gtk_table_attach (table, cinfo_view->button_text_filename, 2, 3, 1, 2,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->button_text_directory, 2, 3, 2, 3,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->button_text_url, 2, 3, 3, 4,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
	gtk_table_attach (table, cinfo_view->button_text_message, 2, 3, 4, 5,
	                  GTK_FILL, GTK_SHRINK, 0, 2);
*/
	gtk_widget_show_all (GTK_WIDGET (top_table));

	// set default page and focus
	gtk_notebook_set_current_page (GTK_NOTEBOOK (cinfo_view->self), 0);
	gtk_widget_grab_focus (cinfo_view->entry);
}

void category_info_view_set (CategoryInfoView* cinfo_view, CategoryNode* cnode)
{
	download_info_view_set (&cinfo_view->dinfo_view, cnode->download_default);

	if ( cinfo_view->multiple == FALSE )
		gtk_entry_set_text (GTK_ENTRY(cinfo_view->entry), (cnode->name) ? cnode->name : "");

	gtk_spin_button_set_value (GTK_SPIN_BUTTON(cinfo_view->spin_download),
	                           cnode->active_max);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(cinfo_view->spin_completed),
	                           cnode->completed_capacity);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(cinfo_view->spin_recycled),
	                           cnode->recycled_capacity);
/*
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_col_completed),
	                              cnode->col_completed);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_col_total),
	                              cnode->col_total);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_col_speed),
	                              cnode->col_speed);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_col_retry),
	                              cnode->col_retry);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_col_url),
	                              cnode->col_url);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_text_filename),
	                              cnode->text_filename);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_text_directory),
	                              cnode->text_directory);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_text_url),
	                              cnode->text_url);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cinfo_view->button_text_message),
	                              cnode->text_message);
*/
}

void category_info_view_get (CategoryInfoView* cinfo_view, CategoryNode* cnode)
{
	download_info_view_get (&cinfo_view->dinfo_view, cnode->download_default);

	if ( cinfo_view->multiple == FALSE ) {
		category_node_set_name (cnode, gtk_entry_get_text (GTK_ENTRY(cinfo_view->entry)));
	}

	cnode->active_max = gtk_spin_button_get_value_as_int (
	                                 GTK_SPIN_BUTTON(cinfo_view->spin_download));
	cnode->completed_capacity = gtk_spin_button_get_value_as_int (
	                                 GTK_SPIN_BUTTON(cinfo_view->spin_completed));
	cnode->recycled_capacity = gtk_spin_button_get_value_as_int (
	                                 GTK_SPIN_BUTTON(cinfo_view->spin_recycled));
/*
	cnode->col_completed = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_col_completed));
	cnode->col_total = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_col_total));
	cnode->col_speed = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_col_speed));
	cnode->col_retry = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_col_retry));
	cnode->col_url = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_col_url));

	cnode->text_filename = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_text_filename));
	cnode->text_directory = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_text_directory));
	cnode->text_url = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_text_url));
	cnode->text_message = gtk_toggle_button_get_active (
	                             GTK_TOGGLE_BUTTON(cinfo_view->button_text_message));
*/
}

void category_info_view_set_multiple (CategoryInfoView *cinfo_view, gboolean multiple)
{
	cinfo_view->multiple = multiple;

	if ( multiple ) {
		gtk_widget_hide (cinfo_view->entry);
		gtk_widget_hide (cinfo_view->label_name);
		gtk_widget_set_sensitive (cinfo_view->entry, FALSE);
		gtk_widget_set_sensitive (cinfo_view->label_name, FALSE);
	}
	else {
		gtk_widget_show (cinfo_view->entry);
		gtk_widget_show (cinfo_view->label_name);
		gtk_widget_set_sensitive (cinfo_view->entry, TRUE);
		gtk_widget_set_sensitive (cinfo_view->label_name, TRUE);
	}
}

