/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __CATEGORY_INFO_VIEW_H
#define __CATEGORY_INFO_VIEW_H

#include <urlglib/category_node.h>
#include "download_info_view.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _CategoryInfoView     CategoryInfoView;

struct _CategoryInfoView {
	DownloadInfoView  dinfo_view;

	GtkWidget* self;
	GtkWidget* label_name;
	GtkWidget* entry;
	GtkWidget* spin_download;
	GtkWidget* spin_completed;
	GtkWidget* spin_recycled;

	gboolean   multiple;
};

void category_info_view_init (CategoryInfoView* cinfo_view);

void category_info_view_set (CategoryInfoView* cinfo_view, CategoryNode* cnode);
void category_info_view_get (CategoryInfoView* cinfo_view, CategoryNode* cnode);
void category_info_view_set_multiple (CategoryInfoView *cinfo_view, gboolean multiple);

#ifdef __cplusplus
}
#endif

#endif  // End of __CATEGORY_INFO_VIEW_H

