/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

/*
 *  Code base on Gtk+ 2.0 Tree View tutorial 
 *      - a tutorial covering GtkTreeView by Tim-Philipp Mu"ller
 */

#ifndef __CATEGORY_TREE_MODEL_H
#define __CATEGORY_TREE_MODEL_H

#include <gtk/gtk.h>
#include <urlglib/root_node.h>

#ifdef __cplusplus
extern "C" {
#endif

#define TYPE_CATEGORY_TREE_MODEL            (category_tree_model_get_type ())
#define CATEGORY_TREE_MODEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CATEGORY_TREE_MODEL, CategoryTreeModel))
#define CATEGORY_TREE_MODEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  TYPE_CATEGORY_TREE_MODEL, CategoryTreeModelClass))
#define IS_CATEGORY_TREE_MODEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CATEGORY_TREE_MODEL))
#define IS_CATEGORY_TREE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  TYPE_CATEGORY_TREE_MODEL))
#define CATEGORY_TREE_MODEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  TYPE_CATEGORY_TREE_MODEL, CategoryTreeModelClass))

typedef struct _CategoryTreeModel       CategoryTreeModel;
typedef struct _CategoryTreeModelClass  CategoryTreeModelClass;

struct _CategoryTreeModel {
	GObject        parent;      /* this MUST be the first member */

	gint           stamp;       /* Random integer to check whether an iter belongs to our model */
	BaseNode*      node;
	UrlglibSignal* inserted_signal;
	UrlglibSignal* removed_signal;
};

struct _CategoryTreeModelClass {
	GObjectClass parent_class;
};

GType          category_tree_model_get_type (void);

CategoryTreeModel* category_tree_model_new (RootNode* parent);


#ifdef __cplusplus
}
#endif

#endif  // End of __CATEGORY_TREE_MODEL_H

