/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <urlglib/ug_i18n.h>
#include <urlglib/category_node.h>
#include "category_tree_view.h"
#include "state_icons.h"

// Category Tree View ------------------------------------------------

static void col_set_icon (GtkTreeViewColumn *tree_column,
                          GtkCellRenderer   *cell,
                          GtkTreeModel      *model,
                          GtkTreeIter       *iter,
                          gpointer           data)
{
	QueueNode*    qnode;
	CategoryNode* cnode;
	int    position;
	int    state;

	gtk_tree_model_get (model, iter, 0, &qnode, -1);
	cnode = queue_node_get_category (qnode);
	if (cnode == NULL)
		return;
	position = base_node_child_position (BASE_NODE (cnode), BASE_NODE (qnode));
	switch (position) {
	case 0:  // waiting queue
		state = (cnode->active_list) ? STATE_ICON_ACTIVE : STATE_ICON_WAITING;
		break;
	case 1:  // completed queue
		state = STATE_ICON_COMPLETED;
		break;
	case 2:  // recycled queue
		state = STATE_ICON_RECYCLED;
		break;
	default:
		state = STATE_ICON_ERROR;
	}

	g_object_set (cell, "pixbuf", state_icons[state], NULL);
}

static void col_set_name (GtkTreeViewColumn *tree_column,
                          GtkCellRenderer   *cell,
                          GtkTreeModel      *model,
                          GtkTreeIter       *iter,
                          gpointer           data)
{
	QueueNode*    qnode;
	CategoryNode* cnode;
	int    position;
	gchar* string;

	gtk_tree_model_get (model, iter, 0, &qnode, -1);
	cnode = queue_node_get_category (qnode);
	if (cnode == NULL)
		return;
	position = base_node_child_position (BASE_NODE (cnode), BASE_NODE (qnode));
	switch (position) {
	case 0:  // waiting queue
		string = cnode->name;
		break;
	case 1:  // completed queue
		string = _("Completed");
		break;
	case 2:  // recycled queue
		string = _("Recycled");
		break;
	default:
		string = "Program Error";
	}

	g_object_set (cell, "text", string, NULL);
}

static void col_set_jobs (GtkTreeViewColumn *tree_column,
                          GtkCellRenderer   *cell,
                          GtkTreeModel      *model,
                          GtkTreeIter       *iter,
                          gpointer           data)
{
	QueueNode*    qnode;
	gchar* string;
	int    n_jobs;

	gtk_tree_model_get (model, iter, 0, &qnode, -1);
	n_jobs = queue_node_n_download (qnode);

	string = g_strdup_printf ("%u", n_jobs);
	g_object_set (cell, "text", string, NULL);
	g_free (string);
}

GtkTreeView* category_tree_view_new ()
{
	GtkTreeView*       tview;
	GtkCellRenderer*   renderer;
	GtkTreeViewColumn* column;

	tview = (GtkTreeView*)gtk_tree_view_new ();
//	gtk_tree_view_set_headers_visible (tview, FALSE);

	state_icons_render ((GtkWidget*)tview);

	// column name
	column = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (column, _("Category"));
	renderer = gtk_cell_renderer_pixbuf_new ();
	gtk_tree_view_column_pack_start (column, renderer, FALSE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         col_set_icon,
	                                         NULL, NULL);
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         col_set_name,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
//	gtk_tree_view_column_set_min_width (column, 120);
	gtk_tree_view_column_set_expand (column, TRUE);
//	gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_append_column (tview, column);

	// column jobs
	column = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (column, _("Quantity"));
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 1.0, NULL);
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         col_set_jobs,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_column_set_alignment (column, 1.0);
//	gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_append_column (tview, column);

	gtk_widget_show (GTK_WIDGET (tview));
	return tview;
}

// Category List View ------------------------------------------------

static void list_col_set_icon (GtkTreeViewColumn *tree_column,
                               GtkCellRenderer   *cell,
                               GtkTreeModel      *model,
                               GtkTreeIter       *iter,
                               gpointer           data)
{
	g_object_set (cell, "pixbuf", state_icons[STATE_ICON_WAITING], NULL);
}

static void list_col_set_name (GtkTreeViewColumn *tree_column,
                               GtkCellRenderer   *cell,
                               GtkTreeModel      *model,
                               GtkTreeIter       *iter,
                               gpointer           data)
{
	CategoryNode* cnode;

	gtk_tree_model_get (model, iter, 0, &cnode, -1);

	g_object_set (cell, "text", cnode->name, NULL);
}

GtkTreeView* category_list_view_new ()
{
	GtkTreeView*       tview;
	GtkCellRenderer*   renderer;
	GtkTreeViewColumn* column;

	tview = (GtkTreeView*)gtk_tree_view_new ();

	state_icons_render ((GtkWidget*)tview);

	// column name
	column = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (column, _("Category name"));
	renderer = gtk_cell_renderer_pixbuf_new ();
	gtk_tree_view_column_pack_start (column, renderer, FALSE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         list_col_set_icon,
	                                         NULL, NULL);
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         list_col_set_name,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
//	gtk_tree_view_column_set_min_width (column, 120);
	gtk_tree_view_column_set_expand (column, TRUE);
//	gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_append_column (tview, column);

	return tview;
}

