/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __DOWNLOAD_DIALOG_H
#define __DOWNLOAD_DIALOG_H

#include <urlglib/root_node.h>
#include "download_info_view.h"

//
// DownloadDilaog
// |
// `--- DownloadImporter
//      |
//      +--- BatchImporter
//      |
//      `--- FilterImporter
//

#ifdef __cplusplus
extern "C" {
#endif

#define DOWNLOAD_DIALOG_FIELDS         \
	DownloadInfoView    dinfo_view;    \
	DownloadDialogFunc  finalize;      \
	GtkDialog*  self;                  \
	GtkTable*   table;                 \
	GtkWidget*  button_skip;           \
	RootNode*          rnode;          \
	GtkWidget*         title_category; \
	GtkScrolledWindow* scrolled;       \
	GtkTreeView*       treeview;       \
	GtkTreeModel*      model

#define DOWNLOAD_DIALOG(o)         ((DownloadDialog*)(o))

typedef struct _DownloadDialog     DownloadDialog;
typedef void (*DownloadDialogFunc) (DownloadDialog*);

struct _DownloadDialog {
	DOWNLOAD_DIALOG_FIELDS;
};

DownloadDialog* download_dialog_new (GtkWindow* parent, gboolean modal);
void  download_dialog_destroy (DownloadDialog* ddilaog);

void  download_dialog_set_title (DownloadDialog* dd, const gchar* title);
void  download_dialog_set_modal (DownloadDialog* dd, gboolean modal);

void  download_dialog_set_category (DownloadDialog* dd, RootNode* rnode, CategoryNode* cnode);
CategoryNode* download_dialog_get_category (DownloadDialog* dd);

gint  download_dialog_run (DownloadDialog* dd);
gboolean download_dialog_handle_error (DownloadDialog* dd);
const char*   download_dialog_get_error_string (DownloadDialog* dd);

// protected functions
void download_dialog_init (DownloadDialog*dd, GtkWindow* parent);
void download_dialog_finalize (DownloadDialog*dd);

#ifdef __cplusplus
}
#endif

#endif  // End of __DOWNLOAD_DIALOG_H

