/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __DOWNLOAD_IMPORTER_H
#define __DOWNLOAD_IMPORTER_H

#include <urlglib/url_filter.h>
#include "download_dialog.h"
#include "main_app.h"

//
// DownloadDilaog
// |
// `--- DownloadImporter
//      |
//      +--- DownloadApplying
//      |
//      +--- BatchImporter
//      |
//      `--- FilterImporter
//

#ifdef __cplusplus
extern "C" {
#endif

#define DOWNLOAD_IMPORTER_FIELDS                                \
	DOWNLOAD_DIALOG_FIELDS;                                     \
	void  (*destroy) (DownloadImporter* dim, gpointer data);    \
	char* (*get)     (DownloadImporter* dim, gpointer data);    \
	gpointer     user_data;                                     \
	MainApp*     main_app;                                      \
	gchar*       title_base;                                    \
	GtkWidget*            frame_import_mode;                    \
	GtkToggleButton*      toggle_apply_all;                     \
	GtkToggleButton*      toggle_one_by_one

#define DOWNLOAD_IMPORTER(o)        ((DownloadImporter*)(o))

typedef struct _DownloadImporter    DownloadImporter;

struct _DownloadImporter {
	DOWNLOAD_IMPORTER_FIELDS;
};

DownloadImporter* download_importer_new (GtkWindow* parent, MainApp* app);
#define download_importer_destroy(o)  download_dialog_destroy(DOWNLOAD_DIALOG (o))

void  download_importer_activate (DownloadImporter* dim);
void  download_importer_activate_1 (DownloadImporter* dim, const gchar* url);

// mode 0 : apply all jobs
// mode 1 : one by one
int   download_importer_get_mode (DownloadImporter* dim);
void  download_importer_set_mode (DownloadImporter* dim, int mode);

void  download_importer_set_progress (DownloadImporter* dim, int n_current, int n_total);
void  download_importer_set_title (DownloadImporter* dim, gchar* title);

// protected functions
void download_importer_init (DownloadImporter* dim, GtkWindow* parent, MainApp* app);
void download_importer_finalize (DownloadImporter* dim);

#ifdef __cplusplus
}
#endif

#endif  // End of __DOWNLOAD_IMPORTER_H

