/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


#ifndef __DOWNLOAD_INFO_VIEW_H
#define __DOWNLOAD_INFO_VIEW_H

#include <gtk/gtk.h>
#include <urlglib/download_node.h>
#include "proxy_editor.h"

#ifdef __cplusplus
extern "C" {
#endif

#define DOWNLOAD_SETTING_VIEW(o)    ((DownloadInfoView*)(o))

typedef struct _DownloadInfoView DownloadInfoView;

struct _DownloadInfoView {
	ProxyEditor proxy_editor;
	GtkWidget* self;             // GtkNotebook
	GtkWindow* parent;

	GtkWidget* button_folder;
	GtkWidget* combo_dir;
	GtkWidget* label_url;
	GtkWidget* label_filename;
	GtkWidget* label_referer;
	GtkWidget* entry_url;
	GtkWidget* entry_dir;
	GtkWidget* entry_filename;
	GtkWidget* entry_referer;

	// widgets for login fields
	GtkWidget* toggle_login;
	GtkWidget* label_username;
	GtkWidget* label_password;
	GtkWidget* entry_username;
	GtkWidget* entry_password;

	// widgets for Start Mode
	GtkWidget* radio_auto;
	GtkWidget* radio_manual;

	GtkWidget* spin_parts;
	GtkWidget* spin_redirect;
	GtkWidget* spin_retry;
	GtkWidget* spin_delay;

	// automatically complete filename from url
	// if auto_complete == FALSE, turn off this function
	gboolean   auto_complete;
	gboolean   url_changed;
	gboolean   multiple;
};

enum DOWNLOAD_INFO_VIEW_COMPLETE {
	DOWNLOAD_INFO_COMPLETE,
	DOWNLOAD_INFO_UNCOMPLETE,
	DOWNLOAD_INFO_UNCOMPLETE_MULTIPlE,
	DOWNLOAD_INFO_UNCOMPLETE_URL
};

void download_info_view_init (DownloadInfoView* view);

void download_info_view_apply (DownloadInfoView* view, DownloadNode* dnode);
void download_info_view_set (DownloadInfoView* view, DownloadNode* dnode);
void download_info_view_get (DownloadInfoView* view, DownloadNode* dnode);
void download_info_view_set_url (DownloadInfoView* view, const gchar* url);

// Login data : Login to Server, include username, password
// Proxy data : All proxy related data
// Exclusive data : URL, filename
void download_info_view_get_login (DownloadInfoView* view, DownloadNode* dnode);
void download_info_view_get_proxy (DownloadInfoView* view, DownloadNode* dnode);
void download_info_view_get_exclusive (DownloadInfoView* view, DownloadNode* dnode);

void download_info_view_auto_complete (DownloadInfoView* view, int flag);
void download_info_view_url_changed (DownloadInfoView* view);

// return : enum DOWNLOAD_INFO_VIEW_COMPLETE
gint download_info_view_check_field (DownloadInfoView* view);

void download_info_view_set_history (DownloadInfoView* dsv, GList* directory_history);
void download_info_view_set_multiple (DownloadInfoView *view, gboolean multiple);


#ifdef __cplusplus
}
#endif

#endif  /* End of __DOWNLOAD_INFO_VIEW_H */
