/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __FILTER_IMPORTER_H
#define __FILTER_IMPORTER_H

#include <urlglib/url_filter.h>
#include "download_importer.h"
#include "url_filter_dialog.h"
#include "main_app.h"

//
// DownloadDilaog
// |
// `--- DownloadImporter
//      |
//      +--- DownloadApplying
//      |
//      +--- BatchImporter
//      |
//      `--- FilterImporter
//

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _FilterImporter    FilterImporter;

struct _FilterImporter {
	DOWNLOAD_IMPORTER_FIELDS;

	UrlFilterDialog* filter_dialog;
	GSList*  filter_list;
	GSList*  marked_list;
	int  n_total;
	int  n_current;
};

FilterImporter* filter_importer_new (GtkWindow* parent, MainApp* app);
#define filter_importer_destroy(o)  download_dialog_destroy(DOWNLOAD_DIALOG (o))

void filter_importer_activate (FilterImporter* fim);
void filter_importer_add (FilterImporter* fim, UrlFilter* filter, gchar* label_name);
void filter_importer_set_title (FilterImporter* fim, gchar* title);

void filter_importer_activate (FilterImporter* fim);

// protected function
void filter_importer_finalize (FilterImporter* fim);

#ifdef __cplusplus
}
#endif

#endif  // End of __FILTER_IMPORTER_H

