/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include "global_dialog.h"
#include <urlglib/ug_i18n.h>

GlobalDialog* global_dialog_new (GtkWindow* parent)
{
	GlobalDialog* gd = g_malloc (sizeof (GlobalDialog));
	GtkWidget* label;
	GtkWidget* hbox;
	GtkWidget* vbox;
	GtkWidget* frame;

	gd->self = (GtkDialog*) gtk_dialog_new_with_buttons (_("Global Setting"),
                                                         parent,
	    (GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR | GTK_DIALOG_DESTROY_WITH_PARENT),
	                                                     GTK_STOCK_CANCEL,
	                                                     GTK_RESPONSE_CANCEL,
	                                                     GTK_STOCK_OK,
	                                                     GTK_RESPONSE_OK,
	                                                     NULL);
	gtk_window_set_default_size (GTK_WINDOW (gd->self), 250, 250);
	vbox = gd->self->vbox;
	gtk_box_set_spacing (GTK_BOX (vbox), 10);

	hbox = gtk_hbox_new (FALSE, 5);
	gtk_container_set_border_width (GTK_CONTAINER(hbox), 5);

	gd->spin_active_category = gtk_spin_button_new_with_range (1.0, 9.0, 1.0);
	label = gtk_label_new_with_mnemonic (_("Active _categories:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL(label), gd->spin_active_category);

	gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(hbox), gd->spin_active_category, FALSE, FALSE, 0);

	frame = gtk_frame_new (_("Clipboard"));
	gtk_box_pack_start (GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	vbox = gtk_vbox_new (FALSE, 5);
	gtk_container_add (GTK_CONTAINER (frame), vbox);
	gtk_container_set_border_width (GTK_CONTAINER(vbox), 5);

	gd->button_monitoring = gtk_check_button_new_with_mnemonic (_("Monitoring clipboard"));
	gtk_box_pack_start (GTK_BOX(vbox), gd->button_monitoring, FALSE, FALSE, 0);

	label = gtk_label_new_with_mnemonic (_("\nMonitor file _types: \n(Perl Compatible Regular Expressions)"));
	gd->entry_extention = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox), gd->entry_extention, TRUE, TRUE, 0);

	gtk_widget_show_all (gd->self->vbox);

	return gd;
}

void global_dialog_destroy (GlobalDialog* gd)
{
	gtk_widget_destroy (GTK_WIDGET (gd->self));
	g_free (gd);
}

void   global_dialog_set_active_category (GlobalDialog* gd, int n)
{
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (gd->spin_active_category),n);
}

int    global_dialog_get_active_category (GlobalDialog* gd)
{
	return gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (gd->spin_active_category));
}

void     global_dialog_set_monitoring (GlobalDialog* gd, gboolean m)
{
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(gd->button_monitoring), m);
}

gboolean global_dialog_get_monitoring (GlobalDialog* gd)
{
	return gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(gd->button_monitoring) );
}

void        global_dialog_set_type (GlobalDialog* gd, const char* type_str)
{
	gtk_entry_set_text (GTK_ENTRY (gd->entry_extention), (type_str) ? type_str : "");
}

const char* global_dialog_get_type (GlobalDialog* gd)
{
	return gtk_entry_get_text (GTK_ENTRY (gd->entry_extention));
}

/*
void global_dialog_set (GlobalDialog* gd, GlobalSetting* setting)
{
	gchar* ext_str;

	gtk_spin_button_set_value (GTK_SPIN_BUTTON(gd->spin_active_category),
	                           setting->n_active_category);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(gd->button_visible),
	                              setting->header_category_visible);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(gd->button_monitoring),
	                              setting->monitoring_clipboard);

	ext_str = global_setting_get_extention (setting);
	gtk_entry_set_text (GTK_ENTRY (gd->entry_extention), ext_str);
	g_free (ext_str);
}

void global_dialog_get (GlobalDialog* gd, GlobalSetting* setting)
{
	setting->n_active_category = gtk_spin_button_get_value_as_int (
	                                GTK_SPIN_BUTTON(gd->spin_active_category) );
	setting->header_category_visible = gtk_toggle_button_get_active (
	                                GTK_TOGGLE_BUTTON(gd->button_visible) );

	setting->monitoring_clipboard = gtk_toggle_button_get_active (
	                                GTK_TOGGLE_BUTTON(gd->button_monitoring) );
	global_setting_set_extention (setting,
	                     gtk_entry_get_text (GTK_ENTRY (gd->entry_extention)) );
}
*/

