/*
 *
 *   Copyright (C) 2003-2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __GLOBAL_DIALOG_H
#define __GLOBAL_DIALOG_H

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _GlobalDialog GlobalDialog;

struct _GlobalDialog {
	GtkDialog* self;

	GtkWidget* spin_active_category;

	GtkWidget* button_monitoring;
	GtkWidget* entry_extention;
};

GlobalDialog* global_dialog_new (GtkWindow* parent);
void global_dialog_destroy (GlobalDialog* gd);

void   global_dialog_set_active_category (GlobalDialog* gd, int n);
int    global_dialog_get_active_category (GlobalDialog* gd);

void     global_dialog_set_monitoring (GlobalDialog* gd, gboolean m);
gboolean global_dialog_get_monitoring (GlobalDialog* gd);

void        global_dialog_set_type (GlobalDialog* gd, const char* type_str);
const char* global_dialog_get_type (GlobalDialog* gd);

#ifdef __cplusplus
}
#endif

#endif  // End of __GLOBAL_DIALOG_H

