/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <urlglib/url_filter.h>
#include "item_list_view.h"

static void col_set_string (GtkTreeViewColumn *tree_column,
                            GtkCellRenderer   *cell,
                            GtkTreeModel      *model,
                            GtkTreeIter       *iter,
                            gpointer          *data)
{
	UrlItem* url_item;
	gchar* string;

	gtk_tree_model_get (model, iter, 0, &url_item, -1);
	string = url_item->string;
	if (string==NULL || *string == 0)
	    string = "(null)";
	g_object_set (cell, "text", string, NULL);
}

static void col_set_toggle (GtkTreeViewColumn *tree_column,
                            GtkCellRenderer   *cell,
                            GtkTreeModel      *model,
                            GtkTreeIter       *iter,
                            gpointer          *data)
{
	UrlItem* url_item;

	gtk_tree_model_get (model, iter, 0, &url_item, -1);
	g_object_set (cell, "active", url_item->mark, NULL);
}

static void on_toggled (GtkCellRendererToggle* cell,
                        gchar*                 path_str,
                        GtkTreeView*           view)
{
	GtkTreeIter  iter;
	GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
	GtkTreeModel*  model = gtk_tree_view_get_model (view);
	UrlItem* url_item;

	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, 0, &url_item, -1);
	url_item->mark ^= 1;

	gtk_tree_path_free (path);
}

GtkTreeView* item_list_view_new (gchar* label_title)
{
	GtkTreeView*       view;
	GtkCellRenderer*   renderer;
	GtkTreeViewColumn* column;
	GtkTreeSelection*  selection;

	// initial tree view.
	view = (GtkTreeView*)gtk_tree_view_new ();

	gtk_tree_view_set_rules_hint (view, TRUE);
//	gtk_widget_set_size_request (GTK_WIDGET (view), 120, 120);

/*
	gtk_scrolled_window_set_policy (scrolled,
	                                GTK_POLICY_AUTOMATIC,
	                                GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_IN);
	gtk_container_add (GTK_CONTAINER(scrolled), GTK_WIDGET(view));
*/

	// set tree view selection
	selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);

	// Toggle
	renderer = gtk_cell_renderer_toggle_new ();
	column = gtk_tree_view_column_new ();
//	gtk_tree_view_column_set_title (column, " ");
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         (GtkTreeCellDataFunc)col_set_toggle,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, FALSE);
	gtk_tree_view_column_set_min_width (column, 15);
	gtk_tree_view_append_column (view, column);
	g_signal_connect (renderer, "toggled", G_CALLBACK (on_toggled), view);

	//
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_title (column, label_title);
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         (GtkTreeCellDataFunc)col_set_string,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_column_set_min_width (column, 70);
	gtk_tree_view_append_column (view, column);

	gtk_widget_show_all ((GtkWidget*)view);
	return view;
}
