/*
 *
 *   Copyright (C) 2002-2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __MAIN_APP_H
#define __MAIN_APP_H

#include <gtk/gtk.h>
#include <pcre.h>
#include <urlglib/category_node.h>
#include <urlglib/msg_server.h>
#include "main_window.h"
#include "category_tree_model.h"
#include "view_setting.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _MainApp      MainApp;

struct _MainApp {
	RootNode*          rnode;
	CategoryTreeModel* model;

	GTree*         queue_ctrl_tree;

	MainWindow     window;

	// Timer counter
	int            timer_count;

	// clipboard
	GtkClipboard*  clipboard;
	gchar*         clipboard_text;
	gboolean       clipboard_monitor;
	gboolean       clipboard_processing;
	char*          clipboard_pattern;

	// message
	MsgServer*     msg_server;

	// regexp
	pcre*          pcre_regexp;

	// controlling state
	gboolean       queuing;
	gboolean       queuing_job;
};

void main_app_init (MainApp* app);
void main_app_finalize (MainApp* app);

void main_app_run (MainApp* app);
void main_app_refresh (MainApp* app);
gboolean main_app_load_data (MainApp* app);
gboolean main_app_save_data (MainApp* app);
gboolean main_app_load_conf (MainApp* app);
gboolean main_app_save_conf (MainApp* app);
gboolean main_app_save_all  (MainApp* app);

void     main_app_import_html (MainApp* app, const gchar* filename);
void     main_app_import_text (MainApp* app, const gchar* text, gboolean match_ext);
void     main_app_import_url  (MainApp* app, const gchar* filename);
gboolean main_app_export_url  (MainApp* app, const gchar* filename, QueueNode* qnode);

// return a singly-list for DownloadNode
// All of DownloadNode store in list are reverse order.
GList*  main_app_get_selected_download (MainApp* app);
void    main_app_set_selected_download (MainApp* app, GList* list, int scrolled_mode);

//QueueCtrl* main_app_get_queue_ctrl (MainApp* app, QueueNode* qnode);
void main_app_remove_queue_ctrl (MainApp* app, QueueNode* qnode);

void main_app_set_queuing (MainApp* app, gboolean queuing);
void main_app_job_changed (MainApp* app);

// return old setting of monitor_clipboard
gboolean main_app_monitor_clipboard (MainApp* app, gboolean monitor);

// config writer & parser --------------------------------------------
void main_app_write_conf (MainApp* app, ConfWriter* cw);

extern const GMarkupParser main_app_parser;

#ifdef __cplusplus
}
#endif

#endif  // End of __MAIN_APP_H

