/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __MAIN_APP_CALLBACK_H
#define __MAIN_APP_CALLBACK_H

#include "main_app.h"

#ifdef __cplusplus
extern "C" {
#endif

// MainWindow ---
gboolean main_app_on_delete_event (GtkWidget* widget, GdkEvent* event, MainApp* app);

// Keyboard
gboolean main_app_on_key_press_event (GtkWidget* widget, GdkEventKey* event, MainApp* app);

// File ---
void main_app_on_import_html (GtkWidget* widget, MainApp*);
void main_app_on_import_url  (GtkWidget* widget, MainApp*);
void main_app_on_export_url  (GtkWidget* widget, MainApp*);
void main_app_on_save_all  (GtkWidget* widget, MainApp*);

// Category ---
void main_app_on_category_selected (GtkTreeView*, MainApp*);
void main_app_on_category_new (GtkWidget* widget, MainApp*);
void main_app_on_category_erase (GtkWidget* widget, MainApp*);
void main_app_on_category_prop (GtkWidget* widget, MainApp*);
void main_app_on_category_default (GtkWidget* widget, MainApp*);

// Download ---
void main_app_on_download_new (GtkWidget* widget, MainApp* app);
void main_app_on_download_batch (GtkWidget* widget, MainApp* app);
void main_app_on_download_erase (GtkWidget* widget, MainApp* app);
void main_app_on_download_prop (GtkWidget* widget, MainApp* app);
void main_app_on_download_move_to (GtkWidget* widget, MainApp* app);
void main_app_on_download_move_up (GtkWidget* widget, MainApp* app);
void main_app_on_download_move_down (GtkWidget* widget, MainApp* app);
void main_app_on_download_move_top (GtkWidget* widget, MainApp* app);
void main_app_on_download_move_bottom (GtkWidget* widget, MainApp* app);
void main_app_on_download_start (GtkWidget* widget, MainApp* app);
void main_app_on_download_stop (GtkWidget* widget, MainApp* app);

// Global ---
void main_app_on_global_start (GtkWidget* widget, MainApp* app);
void main_app_on_global_pause (GtkWidget* widget, MainApp* app);
void main_app_on_global_set (GtkWidget* widget, MainApp* app);

// View ---
void main_app_on_view_column_set (GtkWidget* widget, MainApp* app);
void main_app_on_view_msg_item_set (GtkWidget* widget, MainApp* app);

// About
void main_app_on_about (GtkWidget* widget, MainApp* app);

#ifdef __cplusplus
}
#endif

#endif  /* End of __MAIN_APP_CALLBACK_H */
