/*
 *
 *   Copyright (C) 2002-2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __MAIN_WINDOW_H
#define __MAIN_WINDOW_H

#include <gtk/gtk.h>
#include <urlglib/category_node.h>
#include "queue_ctrl.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _MainWindow   MainWindow;
typedef struct _FileMenu     FileMenu;
typedef struct _CategoryMenu CategoryMenu;
typedef struct _DownloadMenu DownloadMenu;
typedef struct _GlobalMenu   GlobalMenu;
typedef struct _ViewMenu     ViewMenu;
typedef struct _HelpMenu     HelpMenu;

struct _FileMenu
{
	GtkMenu*    self;

	GtkWidget*  import_html;
	GtkWidget*  import_url;
	GtkWidget*  export_url;
	GtkWidget*  save_all;
	GtkWidget*  quit;
};

struct _CategoryMenu
{
	GtkMenu*    self;

	GtkWidget*  create;
	GtkWidget*  erase;
	GtkWidget*  properties;
	GtkWidget*  set_default;
};

struct _DownloadMenu
{
	GtkMenu*    self;

	GtkWidget*  create;
	GtkWidget*  add_batch;
	GtkWidget*  erase;
	GtkWidget*  move_to;
	GtkWidget*  move_up;
	GtkWidget*  move_down;
	GtkWidget*  move_top;
	GtkWidget*  move_bottom;
	GtkWidget*  start;
	GtkWidget*  stop;
	GtkWidget*  properties;
};

struct _GlobalMenu
{
	GtkMenu*    self;

	GtkWidget*  start_all;
	GtkWidget*  pause_all;
//	GtkWidget*  start_queuing;
//	GtkWidget*  pause_queuing;
	GtkWidget*  setting;
	GtkWidget*  about;
};

struct _ViewMenu
{
	GtkMenu*    self;

	GtkWidget*  toolbar;
	GtkWidget*  statusbar;

//	GtkWidget*  category_header;
	GtkWidget*  msg_area;
	GtkWidget*  msg_area_items;

	GtkWidget*  download_rules_hint;
	GtkWidget*  columns;
};

struct _HelpMenu
{
	GtkMenu*    self;

	GtkWidget*  about_urlgfe;
};

void file_menu_init (FileMenu* fm, MainWindow* mw);
void category_menu_init (CategoryMenu* cm);
void download_menu_init (DownloadMenu* dm);
void global_menu_init (GlobalMenu* gm);
void view_menu_init (ViewMenu* vm);
void help_menu_init (HelpMenu* hm);

// MainWindow
struct _MainWindow {
	GtkWindow*       self;

	GtkWidget*       vbox;
	GtkWidget*       status_hbox;
	GtkStatusbar*    statusbar;
	GtkImage*        status_image;
	GtkTreeView*     category_view;

	// accelerators
	GtkAccelGroup*     accelgroup;

	// menus
	GtkWidget*    menu_bar;
	FileMenu      file_menu;
	CategoryMenu  category_menu;
	DownloadMenu  download_menu;
	GlobalMenu    global_menu;
	ViewMenu      view_menu;
	HelpMenu      help_menu;

	// toolbar button for category
	GtkWidget*   toolbar;
	GtkWidget*   button_category_new;
	GtkWidget*   button_category_erase;
//	GtkWidget*   button_import;
//	GtkWidget*   button_export;
	// toolbar for Download control
	GtkWidget*   button_start;
	GtkWidget*   button_stop;
	GtkWidget*   button_new;
	GtkWidget*   button_batch;
	GtkWidget*   button_erase;
	GtkWidget*   button_property;
	GtkWidget*   button_move_up;
	GtkWidget*   button_move_down;
	GtkWidget*   button_move_top;
	GtkWidget*   button_move_bottom;

	// text / message
	GtkWidget*    message_area;  // GtkScrolledWindow
	GtkTextView*  text_view;
	GtkTextTag*   text_tag;

	// paned
	GtkPaned*     hpaned;
	GtkPaned*     vpaned;

	// Queue Control
	QueueCtrl*    queue_ctrl;

	// signal handler id for queue
	gulong        id_cursor_changed;
	gulong        id_selection;
	gulong        id_button_event;

	// display setting
	ViewSetting   view_setting;
	gboolean      view_setting_loading;
	// state for work around some (GTK?)issue
	gboolean      download_moving;
//	gboolean      category_moving;
};

void main_window_init (MainWindow* mw);
void main_window_finalize (MainWindow* window);

void main_window_set_queue_ctrl (MainWindow* mw, QueueCtrl* qctrl);
void main_window_set_queue_state (MainWindow* mw, gboolean queuing);
void main_window_set_download_sensitive (MainWindow* mw, gboolean sens);
void main_window_set_category_sensitive (MainWindow* mw, gboolean sens);

void main_window_view_get (MainWindow* mw);
void main_window_view_set (MainWindow* mw);
void main_window_view_apply (MainWindow* mw);

// message area
void main_window_message_area_refresh (MainWindow* mw);
void main_window_message_area_set (MainWindow* mw, DownloadNode* dnode);

// status bar
void main_window_statusbar_refresh (MainWindow* mw);

// setting
void main_window_apply_setting (MainWindow* mw);

#ifdef __cplusplus
}
#endif

#endif  // End of __MAIN_WINDOW_H


