/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

/*
 *  Code base on Gtk+ 2.0 Tree View tutorial 
 *      - a tutorial covering GtkTreeView by Tim-Philipp Mu"ller
 */

#ifndef __NODE_LIST_MODEL_H
#define __NODE_LIST_MODEL_H

#include <gtk/gtk.h>
#include <urlglib/base_node.h>

#ifdef __cplusplus
extern "C" {
#endif

#define TYPE_NODE_LIST_MODEL            (node_list_model_get_type ())
#define NODE_LIST_MODEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LIST_MODEL, NodeListModel))
#define NODE_LIST_MODEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  TYPE_NODE_LIST_MODEL, NodeListModelClass))
#define IS_NODE_LIST_MODEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LIST_MODEL))
#define IS_NODE_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  TYPE_NODE_LIST_MODEL))
#define NODE_LIST_MODEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  TYPE_NODE_LIST_MODEL, NodeListModelClass))

typedef struct _NodeListModel       NodeListModel;
typedef struct _NodeListModelClass  NodeListModelClass;

struct _NodeListModel {
	GObject        parent;      /* this MUST be the first member */

	gint           stamp;       /* Random integer to check whether an iter belongs to our model */
	BaseNode*      node;
	UrlglibSignal* inserted_signal;
	UrlglibSignal* removed_signal;
};

struct _NodeListModelClass {
	GObjectClass parent_class;
};

GType          node_list_model_get_type (void);

NodeListModel* node_list_model_new (BaseNode* parent);

#ifdef __cplusplus
}
#endif

#endif  // End of __NODE_LIST_MODEL_H
