/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __PROXY_EDITOR_H
#define __PROXY_EDITOR_H

#include <urlglib/download_node.h>
#include "proxy_info_view.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _ProxyEditor   ProxyEditor;

struct _ProxyEditor
{
	ProxyInfoView        proxy_info_view;
	GtkScrolledWindow*   proxy_scrolled;
	GtkWidget*           top_widget;
	DownloadNode*        dnode;

	GtkWidget*      radio_direct;
	GtkWidget*      radio_first;
	GtkWidget*      radio_try_all;
//	GtkWidget*      combo_proxy_mode;
	GtkWidget*      button_proxy_new;
	GtkWidget*      button_proxy_delete;
	GtkWidget*      button_proxy_update;
	GtkWidget*      button_proxy_move_top;
	GtkWidget*      button_proxy_move_up;
	GtkWidget*      button_proxy_move_down;
	GtkWidget*      button_proxy_move_bottom;
	GtkTreeView*    proxy_list_view;
	GtkTreeModel*   proxy_model;

	// state for work around some (GTK?) issue.
	int             moving;      // for on_proxy_cursor_changed ()
	int             deleting;    // for on_proxy_selection () and on_proxy_cursor_changed ()
	int             selection_changed;    // for on_proxy_info_changed ()
};

void proxy_editor_init (ProxyEditor* peditor);
void proxy_editor_decide_sensitive (ProxyEditor* peditor);
void proxy_editor_set (ProxyEditor* peditor, DownloadNode* dnode);
void proxy_editor_get (ProxyEditor* peditor, DownloadNode* dnode);

#ifdef __cplusplus
}
#endif

#endif  /* End of __PROXY_EDITOR_H */

