/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <urlglib/ug_i18n.h>
#include "proxy_info_view.h"

static void on_toggled (GtkWidget* togglebutton, ProxyInfoView* view)
{
	gboolean auth_sensitive;

	auth_sensitive = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(view->toggle_authentication));

	gtk_widget_set_sensitive (view->label_username, auth_sensitive);
	gtk_widget_set_sensitive (view->label_password, auth_sensitive);
	gtk_widget_set_sensitive (view->entry_username, auth_sensitive);
	gtk_widget_set_sensitive (view->entry_password, auth_sensitive);
}

void proxy_info_view_init (ProxyInfoView* view)
{
	GtkTable*  table;
	GtkWidget* hbox_port;

	// initialize
	view->top_widget = gtk_table_new (3, 5, FALSE);
	table = (GtkTable*)view->top_widget;


	// create and setup widgets  ------------------------------------
	view->combo_type = gtk_combo_box_new_text ();
	view->label_type = gtk_label_new_with_mnemonic (_("Type:"));
	gtk_combo_box_prepend_text (GTK_COMBO_BOX (view->combo_type), "SOCKS v5");
	gtk_combo_box_prepend_text (GTK_COMBO_BOX (view->combo_type), "SOCKS v4");
	gtk_combo_box_prepend_text (GTK_COMBO_BOX (view->combo_type), "HTTP");
	gtk_label_set_mnemonic_widget (GTK_LABEL(view->label_type), view->combo_type);

	view->entry_host = gtk_entry_new ();
	view->spin_port  = gtk_spin_button_new_with_range (0.0, 65535.0, 1.0);
	view->label_host = gtk_label_new_with_mnemonic (_("Host:"));
	view->label_port = gtk_label_new_with_mnemonic (_("Port:"));
	gtk_entry_set_width_chars (GTK_ENTRY (view->spin_port), 5);
	gtk_label_set_mnemonic_widget (GTK_LABEL(view->label_host), view->entry_host);
	gtk_label_set_mnemonic_widget (GTK_LABEL(view->label_port), view->spin_port);
	gtk_entry_set_width_chars (GTK_ENTRY (view->entry_host), 15);
	hbox_port = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox_port), view->spin_port, FALSE, FALSE, 0);

	view->toggle_authentication = gtk_check_button_new_with_mnemonic (_("Authentication"));
	view->entry_username = gtk_entry_new ();
	view->entry_password = gtk_entry_new ();
	view->label_username = gtk_label_new_with_mnemonic (_("Username:"));
	view->label_password = gtk_label_new_with_mnemonic (_("Password:"));
	gtk_entry_set_visibility (GTK_ENTRY (view->entry_password), FALSE);
	gtk_label_set_mnemonic_widget (GTK_LABEL(view->label_username),
	                               view->entry_username);
	gtk_label_set_mnemonic_widget (GTK_LABEL(view->label_password),
	                               view->entry_password);
	gtk_entry_set_width_chars (GTK_ENTRY (view->entry_username), 12);
	gtk_entry_set_width_chars (GTK_ENTRY (view->entry_password), 12);

	// attach left side widgets ---------------------------------------
	gtk_table_attach (table, view->label_type, 0, 1, 0, 1,
	                  GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, view->combo_type, 1, 2, 0, 1,
	                  GTK_FILL | GTK_EXPAND, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, view->label_host, 0, 1, 1, 2,
	                  GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, view->entry_host, 1, 2, 1, 2,
	                  GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	gtk_table_attach (table, view->label_port, 0, 1, 2, 3,
	                  GTK_SHRINK, GTK_SHRINK, 1, 1);
	gtk_table_attach (table, hbox_port, 1, 2, 2, 3,
	                  GTK_FILL, GTK_SHRINK, 1, 1);
//	gtk_table_attach (table, view->spin_port, 1, 2, 2, 3,
//	                  GTK_EXPAND, GTK_SHRINK, 1, 1);

	// attach center separator ----------------------------------------
	gtk_table_attach (table, gtk_vseparator_new (), 2, 3, 0, 3,
	                  GTK_FILL, GTK_FILL, 2, 1);

	// attach right side widgets --------------------------------------
	gtk_table_attach (table, view->toggle_authentication, 3, 5, 0, 1,
	                  GTK_FILL | GTK_EXPAND, GTK_SHRINK, 3, 1);

	// username & password
	gtk_table_attach (table, view->label_username, 3, 4, 1, 2,
	                  GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, view->entry_username, 4, 5, 1, 2,
	                  GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	gtk_table_attach (table, view->label_password, 3, 4, 2, 3,
	                  GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, view->entry_password, 4, 5, 2, 3,
	                  GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);

	gtk_widget_show_all (view->top_widget);

	on_toggled (view->toggle_authentication, view);
	g_signal_connect (view->toggle_authentication, "toggled",
	                  G_CALLBACK(on_toggled), view);
}

void proxy_info_view_set (ProxyInfoView* view, ProxyNode* pnode)
{
	if (pnode==NULL)
		return;

	gtk_entry_set_text (GTK_ENTRY(view->entry_host),
	                    (pnode->host) ? pnode->host : "");
	gtk_entry_set_text (GTK_ENTRY(view->entry_username),
	                    (pnode->username) ? pnode->username : "");
	gtk_entry_set_text (GTK_ENTRY(view->entry_password),
	                    (pnode->password) ? pnode->password : "");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(view->spin_port),
	                           pnode->port);

	gtk_combo_box_set_active (GTK_COMBO_BOX (view->combo_type), pnode->type);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(view->toggle_authentication),
	                              pnode->authentication);
	on_toggled (view->toggle_authentication, view);
}

void proxy_info_view_get (ProxyInfoView* view, ProxyNode* pnode)
{
	proxy_node_set_host (pnode, gtk_entry_get_text (GTK_ENTRY(view->entry_host)));
	proxy_node_set_username (pnode, gtk_entry_get_text (GTK_ENTRY(view->entry_username)));
	proxy_node_set_password (pnode, gtk_entry_get_text (GTK_ENTRY(view->entry_password)));
	pnode->port = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(view->spin_port));

	pnode->type = gtk_combo_box_get_active (GTK_COMBO_BOX (view->combo_type));
	pnode->authentication = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (view->toggle_authentication));
}

