/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include "proxy_list_view.h"
#include <urlglib/proxy_node.h>
#include <urlglib/ug_i18n.h>

// static GtkListStore*  proxy_type_model = NULL;

static void col_set_address (GtkTreeViewColumn *tree_column,
                             GtkCellRenderer   *cell,
                             GtkTreeModel      *model,
                             GtkTreeIter       *iter,
                             gpointer          *data)
{
	ProxyNode* pnode;

	gtk_tree_model_get (model, iter, 0, &pnode, -1);
	g_object_set (cell, "text", pnode->host, NULL);
}

static void col_set_port    (GtkTreeViewColumn *tree_column,
                             GtkCellRenderer   *cell,
                             GtkTreeModel      *model,
                             GtkTreeIter       *iter,
                             gpointer          *data)
{
	ProxyNode* pnode;
	gchar* string;

	gtk_tree_model_get (model, iter, 0, &pnode, -1);
	string = g_strdup_printf ("%d", pnode->port);
	g_object_set (cell, "text", string, NULL);
	g_free (string);
}

static void col_set_type    (GtkTreeViewColumn *tree_column,
                             GtkCellRenderer   *cell,
                             GtkTreeModel      *model,
                             GtkTreeIter       *iter,
                             gpointer          *data)
{
	ProxyNode* pnode;
	gchar* string;

	gtk_tree_model_get (model, iter, 0, &pnode, -1);
	switch (pnode->type) {
	case PROXY_TYPE_SOCKS4:
		string = "SOCKS v4";
		break;
	case PROXY_TYPE_SOCKS5:
		string = "SOCKS v5";
		break;
	case PROXY_TYPE_HTTP:
	default:
		string = "HTTP";
	}

	g_object_set (cell, "text", string, NULL);
}

/*
static void col_set_toggle (GtkTreeViewColumn *tree_column,
                            GtkCellRenderer   *cell,
                            GtkTreeModel      *model,
                            GtkTreeIter       *iter,
                            gpointer          *data)
{
	ProxyNode* pnode;

	gtk_tree_model_get (model, iter, 0, &pnode, -1);
	g_object_set (cell, "active", pnode->authentication, NULL);
}

static void on_toggled (GtkCellRendererToggle* cell,
                        gchar*                 path_str,
                        GtkTreeView*           view)
{
	GtkTreePath*  path  = gtk_tree_path_new_from_string (path_str);
	GtkTreeModel* model = gtk_tree_view_get_model (view);
	GtkTreeIter   iter;
	ProxyNode*    pnode;

	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, 0, &pnode, -1);
	pnode->authentication ^= 1;

	gtk_tree_path_free (path);
}

static void col_set_username(GtkTreeViewColumn *tree_column,
                             GtkCellRenderer   *cell,
                             GtkTreeModel      *model,
                             GtkTreeIter       *iter,
                             gpointer          *data)
{
	ProxyNode* pnode;

	gtk_tree_model_get (model, iter, 0, &pnode, -1);
	g_object_set (cell, "text", pnode->username, NULL);
}

static void col_set_password(GtkTreeViewColumn *tree_column,
                             GtkCellRenderer   *cell,
                             GtkTreeModel      *model,
                             GtkTreeIter       *iter,
                             gpointer          *data)
{
	ProxyNode* pnode;

	gtk_tree_model_get (model, iter, 0, &pnode, -1);
	g_object_set (cell, "text", pnode->password, NULL);
}
*/

/*
// Cell editing
// "proxy_column_type"
enum  {
	PROXY_COL_ADDRESS,
	PROXY_COL_PORT,
	PROXY_COL_USERNAME,
	PROXY_COL_PASSWORD
};

static void cell_edited (GtkCellRendererText *cell,
                         const gchar         *path_string,
                         const gchar         *new_text,
                         gpointer             data)
{
	GtkTreeView*  tview = (GtkTreeView*) data;
	GtkTreeModel* model;
	GtkTreePath*  path;
	GtkTreeIter   iter;
	ProxyNode*    pnode;
	int     column_type;

	model = gtk_tree_view_get_model (tview);
	path = gtk_tree_path_new_from_string (path_string);
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, 0, &pnode, -1);
	gtk_tree_path_free (path);
	column_type = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (cell), "proxy_column_type"));

	switch (column_type) {
	case PROXY_COL_ADDRESS:
		proxy_node_set_address (pnode, new_text);
		break;
	case PROXY_COL_PORT:
		pnode->port = atoi (new_text);
		break;
	case PROXY_COL_USERNAME:
		proxy_node_set_username (pnode, new_text);
		break;
	case PROXY_COL_PASSWORD:
		proxy_node_set_password (pnode, new_text);
		break;
	}
}
*/

GtkTreeView* proxy_list_view_new ()
{
//	GtkTreeIter        iter;
	GtkTreeView*       tview;
	GtkCellRenderer*   renderer;
	GtkTreeViewColumn* column;

	tview = (GtkTreeView*)gtk_tree_view_new ();

//	if (proxy_type_model) {
//		proxy_type_model = gtk_list_store_new (1, G_TYPE_STRING);
//		gtk_list_store_append (proxy_type_model, &iter);
//		gtk_list_store_set (proxy_type_model, &iter, 0, "HTTP", -1);
//		gtk_list_store_append (proxy_type_model, &iter);
//		gtk_list_store_set (proxy_type_model, &iter, 0, "SOCKS v4", -1);
//		gtk_list_store_append (proxy_type_model, &iter);
//		gtk_list_store_set (proxy_type_model, &iter, 0, "SOCKS v5", -1);
//	}

	// column type
	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_text_new ();
//	renderer = gtk_cell_renderer_combo_new ();
	gtk_tree_view_column_set_title (column, _("Type"));
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         (GtkTreeCellDataFunc)col_set_type,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
//	gtk_tree_view_column_set_min_width (column, 50);
	gtk_tree_view_append_column (tview, column);

	// column address
	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_set_title (column, _("Host"));
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         (GtkTreeCellDataFunc)col_set_address,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_column_set_min_width (column, 70);
	gtk_tree_view_column_set_expand (column, TRUE);
	gtk_tree_view_append_column (tview, column);
//	g_signal_connect (renderer, "edited", G_CALLBACK (cell_edited), tview);
//	g_object_set(renderer, "editable", TRUE, NULL);
//	g_object_set_data (G_OBJECT (renderer), "proxy_column_type",
//	                   GINT_TO_POINTER (PROXY_COL_ADDRESS));

//	g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_NUMBER);

	// column port
	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_set_title (column, _("Port"));
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         (GtkTreeCellDataFunc)col_set_port,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
//	gtk_tree_view_column_set_min_width (column, 40);
	gtk_tree_view_append_column (tview, column);
//	g_signal_connect (renderer, "edited", G_CALLBACK (cell_edited), tview);
//	g_object_set(renderer, "editable", TRUE, NULL);
//	g_object_set_data (G_OBJECT (renderer), "proxy_column_type",
//	                   GINT_TO_POINTER (PROXY_COL_PORT));

/*
	// column authentication
	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_toggle_new ();
	gtk_tree_view_column_set_title (column, _("Auth"));
	gtk_tree_view_column_pack_start (column, renderer, FALSE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         (GtkTreeCellDataFunc)col_set_toggle,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, FALSE);
	g_signal_connect (renderer, "toggled", G_CALLBACK (on_toggled), tview);
	gtk_tree_view_append_column (tview, column);

	// renderer for username
	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_set_title (column, _("Username"));
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         (GtkTreeCellDataFunc)col_set_username,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
//	gtk_tree_view_column_set_min_width (column, 40);
	gtk_tree_view_append_column (tview, column);
//	g_signal_connect (renderer, "edited", G_CALLBACK (cell_edited), tview);
//	g_object_set(renderer, "editable", TRUE, NULL);
//	g_object_set_data (G_OBJECT (renderer), "proxy_column_type",
//	                   GINT_TO_POINTER (PROXY_COL_USERNAME));

	// column password
	column = gtk_tree_view_column_new ();
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_set_title (column, _("Password"));
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_cell_data_func (column,
	                                         renderer,
	                                         (GtkTreeCellDataFunc)col_set_password,
	                                         NULL, NULL);
	gtk_tree_view_column_set_resizable (column, TRUE);
//	gtk_tree_view_column_set_min_width (column, 40);
	gtk_tree_view_append_column (tview, column);
//	g_signal_connect (renderer, "edited", G_CALLBACK (cell_edited), tview);
//	g_object_set(renderer, "editable", TRUE, NULL);
//	g_object_set_data (G_OBJECT (renderer), "proxy_column_type",
//	                   GINT_TO_POINTER (PROXY_COL_PASSWORD));
*/
	return tview;
}
