/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include "queue_ctrl.h"
#include "node_list_model.h"
#include "download_list_view.h"

static void disable_runtime_columns (QueueCtrl* qctrl)
{
	GtkTreeViewColumn* column;

	column = gtk_tree_view_get_column (qctrl->view, DOWNLOAD_LIST_VIEW_COMPLETED);
	gtk_tree_view_column_set_visible (column, FALSE);

	column = gtk_tree_view_get_column (qctrl->view, DOWNLOAD_LIST_VIEW_PERCENT);
	gtk_tree_view_column_set_visible (column, FALSE);

	column = gtk_tree_view_get_column (qctrl->view, DOWNLOAD_LIST_VIEW_SPEED);
	gtk_tree_view_column_set_visible (column, FALSE);

	column = gtk_tree_view_get_column (qctrl->view, DOWNLOAD_LIST_VIEW_RETRY);
	gtk_tree_view_column_set_visible (column, FALSE);
}

QueueCtrl* queue_ctrl_new (QueueNode* qnode)
{
	QueueCtrl* qctrl = g_malloc (sizeof (QueueNode));

	qctrl->qnode = qnode;
	qctrl->cnode = queue_node_get_category (qnode);
	qctrl->model = (GtkTreeModel*)node_list_model_new (BASE_NODE (qnode));
	qctrl->view  = download_list_view_new ();
	qctrl->top_widget = gtk_scrolled_window_new (NULL, NULL);
	qctrl->reference_count = 1;

	gtk_widget_set_size_request (GTK_WIDGET (qctrl->top_widget), 120, 120);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (qctrl->top_widget),
	                                     GTK_SHADOW_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(qctrl->top_widget),
	                                GTK_POLICY_AUTOMATIC,
	                                GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (qctrl->top_widget), GTK_WIDGET (qctrl->view));
	gtk_tree_view_set_model (qctrl->view, qctrl->model);
	g_object_ref (qctrl->top_widget);

	if (category_node_waiting_queue (qctrl->cnode) != qnode)
		disable_runtime_columns (qctrl);

	gtk_widget_show_all (qctrl->top_widget);

	return qctrl;
}

void queue_ctrl_ref (QueueCtrl* qctrl)
{
	qctrl->reference_count++;
}

void queue_ctrl_unref (QueueCtrl* qctrl)
{
	if (--qctrl->reference_count == 0) {
		g_object_unref (qctrl->top_widget);
		g_object_unref (qctrl->model);
	}
}

void queue_ctrl_apply_setting (QueueCtrl* qctrl, ViewSetting* vs)
{
	download_list_view_set (qctrl->view, vs);

	if (category_node_waiting_queue (qctrl->cnode) != qctrl->qnode)
		disable_runtime_columns (qctrl);
}

