/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifdef _WIN32
#include <windows.h>
#endif

#include <gtk/gtk.h>
#include <urlglib/download_task_curl.h>
#include <urlglib/msg_client.h>
#include "main_app.h"
#include "urlgfe_util.h"
#include <urlglib/ug_i18n.h>

#ifdef _WIN32
int urlgfe_main (int argc, char *argv[])
#else
int main(int argc, char *argv[])
#endif
{
	MainApp*  mapp;

#ifndef _WIN32
	// add url to existed Urlgfe.
	if (msg_client_ack ()) {
		if (argc > 1)
			msg_client_add_url (argv[1]);
		return 0;
	}
#endif

	urlgfe_path_init (argc, argv);
	download_task_curl_global_init ();

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, urlgfe_path_locale_dir ());
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	if( g_thread_supported()==FALSE )
		g_thread_init(NULL);

	gdk_threads_init();
	gtk_init (&argc, &argv);

	urlgfe_disable_console_output ();

	mapp = g_malloc (sizeof (MainApp));
	main_app_init (mapp);
	main_app_run (mapp);

	// add url from command line if no existed Urlgfe.
	if (argc > 1 && msg_client_ack ())
		msg_client_add_url (argv[1]);

	gdk_threads_enter ();
	gtk_main ();
	gdk_threads_leave ();

	main_app_finalize (mapp);
	download_task_curl_global_finalize ();
	g_free (mapp);

	return 0;
}


#ifdef _WIN32
int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)
{
	WSADATA WSAData;
	gchar *title;
	HWND winhandle;

	WSAStartup (MAKEWORD (1, 1), &WSAData);

	// Find previous window
	title = g_locale_from_utf8(URLGFE_TITLE, -1, NULL, NULL, NULL);
	winhandle = FindWindowA(0, title);
	g_free(title);

	if (winhandle > 0) {
		SetForegroundWindow(winhandle);
		//BringWindowToTop(winhandle); //don't work :(
		//ShowWindow(winhandle, SW_SHOW); //don't work fine, as gtk widgets may still be hiden.
		if (__argc > 1)
			msg_client_add_url (__argv[1]);
		return 0;
	}

	urlgfe_main (__argc, __argv);

	WSACleanup ();

	return 0;
}
#endif

