/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <string.h>
#include <stdlib.h>
#include "view_setting.h"

void view_setting_init (ViewSetting* setting)
{
	setting->download.rules_hint = TRUE;

	setting->download.filename.width  = 120;
	setting->download.completed.width = 70;
	setting->download.total.width     = 70;
	setting->download.percent.width   = 50;
	setting->download.speed.width = 80;
	setting->download.retry.width = 40;
	setting->download.url.width   = 80;

	setting->download.filename.visible  = TRUE;
	setting->download.completed.visible = TRUE;
	setting->download.total.visible     = TRUE;
	setting->download.percent.visible   = TRUE;
	setting->download.speed.visible = TRUE;
	setting->download.retry.visible = TRUE;
	setting->download.url.visible   = FALSE;

	setting->message.visible = TRUE;

	setting->message.filename.visible  = FALSE;
	setting->message.directory.visible = TRUE;
	setting->message.url.visible       = TRUE;
	setting->message.message.visible   = TRUE;

	setting->toolbar_visible   = TRUE;
	setting->statusbar_visible = TRUE;
}

void view_setting_write_conf (ViewSetting* setting, ConfWriter* cw)
{
	conf_writer_start_element (cw, VIEW_SETTING_TAG);

	conf_writer_start_element (cw, "download_list_view");

	conf_writer_start_element (cw, "filename visible=\"%d\" width=\"%d\"",
	                           setting->download.filename.visible,
	                           setting->download.filename.width);
	conf_writer_end_element (cw, "filename");

	conf_writer_start_element (cw, "completed visible=\"%d\" width=\"%d\"",
	                           setting->download.completed.visible,
	                           setting->download.completed.width);
	conf_writer_end_element (cw, "completed");

	conf_writer_start_element (cw, "total visible=\"%d\" width=\"%d\"",
	                           setting->download.total.visible,
	                           setting->download.total.width);
	conf_writer_end_element (cw, "total");

	conf_writer_start_element (cw, "percent visible=\"%d\" width=\"%d\"",
	                           setting->download.percent.visible,
	                           setting->download.percent.width);
	conf_writer_end_element (cw, "percent");

	conf_writer_start_element (cw, "speed visible=\"%d\" width=\"%d\"",
	                           setting->download.speed.visible,
	                           setting->download.speed.width);
	conf_writer_end_element (cw, "speed");

	conf_writer_start_element (cw, "retry visible=\"%d\" width=\"%d\"",
	                           setting->download.retry.visible,
	                           setting->download.retry.width);
	conf_writer_end_element (cw, "retry");

	conf_writer_start_element (cw, "url visible=\"%d\" width=\"%d\"",
	                           setting->download.url.visible,
	                           setting->download.url.width);
	conf_writer_end_element (cw, "url");

	conf_writer_end_element (cw, "download_list_view");

	// message area
	conf_writer_start_element (cw, "message_area visible=\"%d\"",
	                           setting->message.visible);

	conf_writer_start_element (cw, "filename visible=\"%d\"",
	                           setting->message.filename.visible);
	conf_writer_end_element (cw, "filename");

	conf_writer_start_element (cw, "directory visible=\"%d\"",
	                           setting->message.directory.visible);
	conf_writer_end_element (cw, "directory");

	conf_writer_start_element (cw, "url visible=\"%d\"",
	                           setting->message.url.visible);
	conf_writer_end_element (cw, "url");

	conf_writer_start_element (cw, "message visible=\"%d\"",
	                           setting->message.message.visible);
	conf_writer_end_element (cw, "message");

	conf_writer_end_element (cw, "message_area");

	// toolbar
	conf_writer_start_element (cw, "toolbar visible=\"%d\"",
	                           setting->toolbar_visible);
	conf_writer_end_element (cw, "toolbar");

	// statusbar
	conf_writer_start_element (cw, "statusbar visible=\"%d\"",
	                           setting->statusbar_visible);
	conf_writer_end_element (cw, "statusbar");

	conf_writer_end_element (cw, VIEW_SETTING_TAG);
}

static gboolean attr_visible (const char** attr_names, const char** attr_values)
{
	int ii;

	for (ii=0; attr_names[ii]; ii++) {
		if (strcmp (attr_names[ii], "visible")==0) {
			return atoi (attr_values[ii]);
		}
	}
	return 0;
}

// download_list_view parser -----------------------------------------
static void dlist_view_parser_start_element (GMarkupParseContext* gmpc,
                                             const gchar*    element_name,
                                             const gchar**   attr_names,
                                             const gchar**   attr_values,
                                             gpointer        cparser,
                                             GError**        error)
{
	ViewSetting*  setting = CONF_PARSER_DATA (cparser);
	struct __DownloadViewColumn* column;
	int ii;

	if (strcmp (element_name, "filename")==0)
		column = &setting->download.filename;
	else if (strcmp (element_name, "completed")==0)
		column = &setting->download.completed;
	else if (strcmp (element_name, "total")==0)
		column = &setting->download.total;
	else if (strcmp (element_name, "percent")==0)
		column = &setting->download.percent;
	else if (strcmp (element_name, "speed")==0)
		column = &setting->download.speed;
	else if (strcmp (element_name, "retry")==0)
		column = &setting->download.retry;
	else if (strcmp (element_name, "url")==0)
		column = &setting->download.url;

	for (ii=0; attr_names[ii]; ii++) {
		if (strcmp (attr_names[ii], "visible")==0)
			column->visible = atoi (attr_values[ii]);
		else if (strcmp (attr_names[ii], "width")==0)
			column->width = atoi (attr_values[ii]);
	}
}

static void dlist_view_parser_end_element (GMarkupParseContext*  gmpc,
                                           const gchar*      element_name,
                                           gpointer          cparser,
                                           GError**          error)
{
	if (strcmp (element_name, "download_list_view")==0)
		conf_parser_pop (cparser);
}

static const GMarkupParser dlist_view_parser = {
	dlist_view_parser_start_element,
	dlist_view_parser_end_element,
	NULL,
	NULL,
	NULL
};

// message_area parser -----------------------------------------
static void mesg_area_parser_start_element (GMarkupParseContext* gmpc,
                                             const gchar*    element_name,
                                             const gchar**   attr_names,
                                             const gchar**   attr_values,
                                             gpointer        cparser,
                                             GError**        error)
{
	ViewSetting*  setting = CONF_PARSER_DATA (cparser);
	struct __MessageViewItem* item;
	int ii;

	if (strcmp (element_name, "filename")==0)
		item = &setting->message.filename;
	else if (strcmp (element_name, "directory")==0)
		item = &setting->message.directory;
	else if (strcmp (element_name, "url")==0)
		item = &setting->message.url;
	else if (strcmp (element_name, "message")==0)
		item = &setting->message.message;

	for (ii=0; attr_names[ii]; ii++) {
		if (strcmp (attr_names[ii], "visible")==0)
			item->visible = atoi (attr_values[ii]);
	}
}

static void mesg_area_parser_end_element (GMarkupParseContext*  gmpc,
                                           const gchar*      element_name,
                                           gpointer          cparser,
                                           GError**          error)
{
	if (strcmp (element_name, "message_area")==0)
		conf_parser_pop (cparser);
}

static const GMarkupParser mesg_area_parser = {
	mesg_area_parser_start_element,
	mesg_area_parser_end_element,
	NULL,
	NULL,
	NULL
};

// view_setting parser -----------------------------------------------
void view_setting_parser_start_element (GMarkupParseContext* gmpc,
                                        const gchar*    element_name,
                                        const gchar**   attr_names,
                                        const gchar**   attr_values,
                                        gpointer        cparser,
                                        GError**        error)
{
	ViewSetting*  setting = CONF_PARSER_DATA (cparser);

	if (strcmp (element_name, "download_list_view")==0) {
		conf_parser_push (cparser, &dlist_view_parser, setting);
	} else if (strcmp (element_name, "message_area")==0) {
		conf_parser_push (cparser, &mesg_area_parser, setting);
		setting->message.visible = attr_visible (attr_names, attr_values);
	} else if (strcmp (element_name, "toolbar")==0) {
		setting->toolbar_visible = attr_visible (attr_names, attr_values);
	} else if (strcmp (element_name, "statusbar")==0) {
		setting->statusbar_visible = attr_visible (attr_names, attr_values);
	}
}

void view_setting_parser_end_element (GMarkupParseContext*  gmpc,
                                      const gchar*      element_name,
                                      gpointer          cparser,
                                      GError**          error)
{
	if (strcmp (element_name, VIEW_SETTING_TAG)==0)
		conf_parser_pop (cparser);
}

const GMarkupParser view_setting_parser = {
	view_setting_parser_start_element,
	view_setting_parser_end_element,
	NULL,
	NULL,
	NULL
};

