/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __VIEW_SETTING_H
#define __VIEW_SETTING_H

#include <glib.h>
#include <urlglib/conf_parser.h>
#include <urlglib/conf_writer.h>

#ifdef __cplusplus
extern "C" {
#endif

#define VIEW_SETTING_TAG       "view_setting"
typedef struct _ViewSetting  ViewSetting;

struct __DownloadViewColumn {
	gboolean visible;
	int      width;
};

struct __DownloadView {
	struct __DownloadViewColumn  filename;
	struct __DownloadViewColumn  completed;
	struct __DownloadViewColumn  total;
	struct __DownloadViewColumn  percent;
	struct __DownloadViewColumn  speed;
	struct __DownloadViewColumn  retry;
	struct __DownloadViewColumn  url;
	gboolean  rules_hint;
};

struct __MessageViewItem {
	gboolean  visible;
};

struct __MessageView {
	struct __MessageViewItem  filename;
	struct __MessageViewItem  directory;
	struct __MessageViewItem  url;
	struct __MessageViewItem  message;
	gboolean  visible;
};

struct _ViewSetting {
	struct __DownloadView  download;
	struct __MessageView   message;
	gboolean toolbar_visible;
	gboolean statusbar_visible;
};

void view_setting_init (ViewSetting* setting);

// config writer & parser --------------------------------------------
void view_setting_write_conf (ViewSetting* app, ConfWriter* cw);

extern const GMarkupParser view_setting_parser;

#ifdef __cplusplus
}
#endif

#endif  // End of __VIEW_SETTING_H
