/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <urlglib/ug_i18n.h>
#include "view_setting_dialog.h"

ViewSettingDialog* view_setting_dialog_new (GtkWindow* parent)
{
	ViewSettingDialog* cvsd;
	GtkWidget* label;
	GtkTable*  table;

	cvsd = g_malloc0 (sizeof (ViewSettingDialog));
	cvsd->self = (GtkDialog*) gtk_dialog_new_with_buttons (_("View setting"),
	                                                       parent,
	                (GTK_DIALOG_NO_SEPARATOR | GTK_DIALOG_DESTROY_WITH_PARENT),
	                                                       GTK_STOCK_CANCEL,
	                                                       GTK_RESPONSE_CANCEL,
	                                                       GTK_STOCK_OK,
	                                                       GTK_RESPONSE_OK,
	                                                       NULL);
	gtk_window_set_default_size (GTK_WINDOW (cvsd->self), 250, 300);
	cvsd->notebook = (GtkNotebook*) gtk_notebook_new ();

	// Message page
	label = gtk_label_new (_("Visible items in message area:"));
	table = (GtkTable*)gtk_table_new (5, 1, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 2);
	cvsd->button_msg_filename = gtk_check_button_new_with_label (_("Filename"));
	cvsd->button_msg_directory = gtk_check_button_new_with_label (_("Directory"));
	cvsd->button_msg_url = gtk_check_button_new_with_label (_("URL"));
	cvsd->button_msg_message = gtk_check_button_new_with_label (_("Message"));
	gtk_table_attach (table, label, 0, 1, 0, 1,
	                  GTK_FILL, GTK_SHRINK, 2, 6);
	gtk_table_attach (table, cvsd->button_msg_filename, 0, 1, 1, 2,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	gtk_table_attach (table, cvsd->button_msg_directory, 0, 1, 2, 3,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	gtk_table_attach (table, cvsd->button_msg_url, 0, 1, 3, 4,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	gtk_table_attach (table, cvsd->button_msg_message, 0, 1, 4, 5,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	label = gtk_label_new (_("Message"));
	gtk_notebook_prepend_page (GTK_NOTEBOOK (cvsd->notebook), GTK_WIDGET (table), label);

	// Column page
	label = gtk_label_new (_("Visible download columns:"));
	table = (GtkTable*)gtk_table_new (7, 1, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 2);
	cvsd->button_col_completed = gtk_check_button_new_with_label (_("Completed"));
	cvsd->button_col_total = gtk_check_button_new_with_label (_("Total"));
	cvsd->button_col_percent = gtk_check_button_new_with_label (_("Percent (%)"));
	cvsd->button_col_speed = gtk_check_button_new_with_label (_("Speed"));
	cvsd->button_col_retry = gtk_check_button_new_with_label (_("Retry"));
	cvsd->button_col_url = gtk_check_button_new_with_label (_("URL"));
	gtk_table_attach (table, label, 0, 1, 0, 1,
	                  GTK_FILL, GTK_SHRINK, 2, 6);
	gtk_table_attach (table, cvsd->button_col_completed, 0, 1, 1, 2,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	gtk_table_attach (table, cvsd->button_col_total, 0, 1, 2, 3,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	gtk_table_attach (table, cvsd->button_col_percent, 0, 1, 3, 4,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	gtk_table_attach (table, cvsd->button_col_speed, 0, 1, 4, 5,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	gtk_table_attach (table, cvsd->button_col_retry, 0, 1, 5, 6,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	gtk_table_attach (table, cvsd->button_col_url, 0, 1, 6, 7,
	                  GTK_FILL, GTK_SHRINK, 6, 2);
	label = gtk_label_new (_("Columns"));
	gtk_notebook_prepend_page (GTK_NOTEBOOK (cvsd->notebook), GTK_WIDGET (table), label);

	gtk_box_pack_start (GTK_BOX (cvsd->self->vbox), GTK_WIDGET (cvsd->notebook), TRUE, TRUE, 0);
	gtk_widget_show_all (cvsd->self->vbox);

	return cvsd;
}

void view_setting_dialog_destroy (ViewSettingDialog* cvsd)
{
	gtk_widget_destroy (GTK_WIDGET (cvsd->self));
	g_free (cvsd);
}

void view_setting_dialog_activate (ViewSettingDialog* vsd)
{
	gtk_widget_show (GTK_WIDGET (vsd->self));
}

void view_setting_dialog_set_page (ViewSettingDialog* cvsd, int n_page)
{
	gtk_notebook_set_current_page (cvsd->notebook, n_page);
}

void view_setting_dialog_get (ViewSettingDialog* cvsd, ViewSetting* setting)
{
	gboolean visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_col_completed));
	setting->download.completed.visible = visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_col_total));
	setting->download.total.visible = visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_col_percent));
	setting->download.percent.visible = visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_col_speed));
	setting->download.speed.visible = visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_col_retry));
	setting->download.retry.visible = visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_col_url));
	setting->download.url.visible = visible;


	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_msg_filename));
	setting->message.filename.visible = visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_msg_directory));
	setting->message.directory.visible = visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_msg_url));
	setting->message.url.visible = visible;

	visible = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(cvsd->button_msg_message));
	setting->message.message.visible = visible;
}

void view_setting_dialog_set (ViewSettingDialog* cvsd, ViewSetting* setting)
{
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_col_completed),
	                              setting->download.completed.visible);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_col_total),
	                              setting->download.total.visible);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_col_percent),
	                              setting->download.percent.visible);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_col_speed),
	                              setting->download.speed.visible);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_col_retry),
	                              setting->download.retry.visible);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_col_url),
	                              setting->download.url.visible);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_msg_filename),
	                              setting->message.filename.visible);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_msg_directory),
	                              setting->message.directory.visible);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_msg_url),
	                              setting->message.url.visible);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cvsd->button_msg_message),
	                              setting->message.message.visible);
}


