/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __CATEGORY_NODE_H
#define __CATEGORY_NODE_H

#include <urlglib/queue_node.h>

#ifdef __cplusplus
extern "C" {
#endif

#define CATEGORY_NODE(obj)           ((CategoryNode*)(obj))
#define CATEGORY_NODE_TAG            "category_setting"

typedef struct _CategoryNode         CategoryNode;

struct _CategoryNode {
	BASE_NODE_FIELDS;

	char*  name;
	int    completed_capacity;
	int    recycled_capacity;
	guint  active_max;
	GList* active_list;
	DownloadNode*    download_default;
};

CategoryNode* category_node_new ();
CategoryNode* category_node_new_without_queue ();

#define category_node_ref(obj)      base_node_ref (BASE_NODE(obj))
#define category_node_unref(obj)    base_node_unref (BASE_NODE(obj))

#define category_node_next(o)       (CategoryNode*)base_node_next(BASE_NODE(o))
#define category_node_prev(o)       (CategoryNode*)base_node_prev(BASE_NODE(o))
#define category_node_unlink(o)     base_node_unlink (BASE_NODE (o))

gboolean  category_node_activate_download (CategoryNode* cnode, DownloadNode* dnode);
#define category_node_n_active_download(cnode)  g_list_length ((cnode)->active_list)

#define category_node_set_name(c,n)      str_replace_no_crlf (&(c)->name, n, -1)

#define category_node_waiting_queue(c)   (QueueNode*)base_node_nth_child (BASE_NODE (c), 0)
#define category_node_completed_queue(c) (QueueNode*)base_node_nth_child (BASE_NODE (c), 1)
#define category_node_recycled_queue(c)  (QueueNode*)base_node_nth_child (BASE_NODE (c), 2)
#define category_node_is_active(c)       ((c)->active_list!=NULL)

void  category_node_refresh (CategoryNode* cnode);

int   category_node_start (CategoryNode* cnode);
void  category_node_stop (CategoryNode* cnode);

// config writer & parser --------------------------------------------
void category_node_write_conf (CategoryNode* cnode, ConfWriter* cw);

void category_node_parser_attr (const gchar**     attr_names,
                                const gchar**     attr_values,
                                CategoryNode*     cnode);
// global
extern const GMarkupParser category_node_parser;

#ifdef __cplusplus
}
#endif

#endif  // End of __CATEGORY_NODE_H
