/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

/*
 *  conf_parser.h
 *      Parse configuration from XML files.
 */

#ifndef __CONF_PARSER_H
#define __CONF_PARSER_H

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _ConfParser         ConfParser;
// GMarkupParser func -----------------------------------------------
typedef void (*MarkupParserStartElementFunc) (GMarkupParseContext* gmpc,
                                              const gchar*    element_name,
                                              const gchar**   attr_names,
                                              const gchar**   attr_values,
                                              gpointer        data,
                                              GError**        error);

typedef void (*MarkupParserEndElementFunc) (GMarkupParseContext*  gmpc,
                                            const gchar*      element_name,
                                            gpointer          data,
                                            GError**          error);

typedef void (*MarkupParserTextFunc) (GMarkupParseContext*  gmpc,
                                      const gchar*          text,
                                      gsize                 text_len,
                                      gpointer              data,
                                      GError**              error);

typedef void (*MarkupParserPassthroughFunc) (GMarkupParseContext*  gmpc,
                                             const gchar*  passthrough_text,
                                             gsize         text_len,  
                                             gpointer      data,
                                             GError**      error);

typedef void (*MarkupParserErrorFunc) (GMarkupParseContext*  gmpc,
                                       GError*               error,
                                       gpointer              data);

struct _ConfParser {
	GMarkupParseContext* parse_context;
	GMarkupParser        parser;
	void*                data;

	GPtrArray*  stack;
//	GPtrArray*  parser_stack;
//	GPtrArray*  data_stack;
};

ConfParser* conf_parser_new ();
void conf_parser_destroy (ConfParser* cp);

void conf_parser_init (ConfParser* cp);
void conf_parser_finalize (ConfParser* cp);

gboolean conf_parser_read_file (ConfParser* cp, const gchar* filename, GError** error);

// push/pop both parser and data
// Use conf_parser_push () and conf_parser_pop () together.
void conf_parser_push (ConfParser* cp, const GMarkupParser* parser, void* data);
void conf_parser_pop (ConfParser* cp);

// push/pop data only, parser keep no changed.
// Use conf_parser_push_parser () and conf_parser_pop_parser () together.
void conf_parser_push_data (ConfParser* cp, void* data);
void conf_parser_pop_data (ConfParser* cp);

// when parse <tag>text</tag>
// conf_parser_push_text_func_defalut () do *p_string = g_strndup (text);
// conf_parser_push_text_func_no_crlf () do *p_string = strndup_no_crlf (text);
void conf_parser_push_text_func (ConfParser* cparser, MarkupParserTextFunc func, gchar** dest_string);
void conf_parser_push_text_func_defalut (ConfParser* cparser, gchar** dest_string);
void conf_parser_push_text_func_no_crlf (ConfParser* cparser, gchar** dest_string);
void conf_parser_pop_text_func (ConfParser* cparser);

// change parser function when parsing
#define conf_parser_set_text_func(cp,fn)    (((ConfParser*)(cp))->parser.text = fn)

#define CONF_PARSER_DATA(obj)   (((ConfParser*)(obj))->data)

#ifdef __cplusplus
}
#endif

#endif  // End of __CONF_PARSER_H

