/*
 *
 *   Copyright (C) 2003-2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __CONF_WRITER_H
#define __CONF_WRITER_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

typedef struct _ConfWriter ConfWriter;

struct _ConfWriter {
	int  element_status;
	// 0 :  element is not ended.   eg. <element
	// 1 :  element was ended.      eg. <element/> or </element>
	// 2 :  element follows text.   eg. <element>text

	int  formating;
	int  level;

	FILE*  file;
};

void conf_writer_init (ConfWriter* cw, int formating);

void conf_writer_finalize (ConfWriter* cw);

int  conf_writer_open_file (ConfWriter* cw, const char* filename);

void conf_writer_start_element (ConfWriter* cw, const char* format_str, ...);

void conf_writer_end_element (ConfWriter* cw, const char* element_name);

void conf_writer_text (ConfWriter* cw, const char* text);

void conf_writer_text_len (ConfWriter* cw, const char* text, int len);

#ifdef __cplusplus
}
#endif

#endif  // End of __CONF_WRITER_H

