/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __HTML_IMPORT_H
#define __HTML_IMPORT_H

#include <glib.h>
#include "url_filter.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _HtmlImport        HtmlImport;
typedef struct _HtmlImportElement HtmlImportElement;

struct _HtmlImportElement {
	UrlFilter*  filter;
	gchar*      element_name;
	gchar*      attr_name;
};

HtmlImportElement* html_import_element_new (UrlFilter* filter, gchar* element_name, gchar* attr_name);
void html_import_element_free (HtmlImportElement* hie);

struct _HtmlImport {
	gchar*      base_href;    // for <base href="some.address">

	GPtrArray*  name_array;
	GPtrArray*  value_array;

	GSList*     element_list;
	GString*    gstring;
};

HtmlImport* html_import_new();
void html_import_free (HtmlImport* html_import);

void html_import_add_element (HtmlImport* html_import, UrlFilter* filter,
                              gchar* element_name, gchar* attr_name);

gboolean html_import_read_file (HtmlImport* hi, const gchar* filename);

#ifdef __cplusplus
}
#endif

#endif  // End of __HTML_IMPORT_H


