/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __MSG_SERVER_H
#define __MSG_SERVER_H

#include <glib.h>

#ifdef _WIN32
# include <winsock.h>
#else
# include <sys/un.h>        // struct sockaddr_un
# ifndef SOCKET
#  define SOCKET  int
# endif
#endif

#define URLGFE_SOCKET_PORT  14777
#define URLGFE_SOCKET_NAME  "urlgfe_msg"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _MsgServer    MsgServer;

struct _MsgServer {
	SOCKET  fd;
	int  reference_count;
	GStaticMutex  mutex;
	GList*   url_list;
	gboolean active;

#ifdef _WIN32
	struct sockaddr_in  addr;
#else
	struct sockaddr_un  addr;
	char* filename;
#endif
};

struct MsgPacket {
	int  type;
	int  length;
};

enum {
	MESSAGE_ACK,
	MESSAGE_ADD,
};

MsgServer* msg_server_new ();
void  msg_server_ref (MsgServer* msgs);
void  msg_server_unref (MsgServer* msgs);

void  msg_server_lock (MsgServer* msgs);
void  msg_server_unlock (MsgServer* msgs);

void  msg_server_activate (MsgServer* msgs);
void  msg_server_stop (MsgServer* msgs);

#ifdef __cplusplus
}
#endif

#endif  // End of __MSG_SERVER_H

