/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __PROXY_NODE_H
#define __PROXY_NODE_H

#include <urlglib/base_node.h>
#include <urlglib/urlglib_util.h>

#ifdef __cplusplus
extern "C" {
#endif

#define PROXY_NODE(obj)           ((ProxyNode*)(obj))
#define PROXY_NODE_TAG            "proxy_setting"

typedef struct _ProxyNode         ProxyNode;

struct _ProxyNode {
	BASE_NODE_FIELDS;

	unsigned int   type;
	unsigned int   authentication;

	unsigned int   port;
	char* host;
	char* username;
	char* password;
};

enum PROXY_NODE_TYPE {
	PROXY_TYPE_HTTP,
	PROXY_TYPE_SOCKS4,
	PROXY_TYPE_SOCKS5
};

ProxyNode* proxy_node_new ();

#define proxy_node_ref(obj)      base_node_ref(BASE_NODE(obj))
void    proxy_node_unref (ProxyNode* pnode);

#define proxy_node_prev(obj)       (ProxyNode*)base_node_prev(BASE_NODE(obj))
#define proxy_node_next(obj)       (ProxyNode*)base_node_next(BASE_NODE(obj))
#define proxy_node_get_download(o) (DownloadNode*)base_node_parent(BASE_NODE(o))

void proxy_node_set_host (ProxyNode* pnode, const char* host);
void proxy_node_set_username (ProxyNode* pnode, const char* username);
void proxy_node_set_password (ProxyNode* pnode, const char* password);

void proxy_node_assign (ProxyNode* dest, ProxyNode* src);
void proxy_node_unlink (ProxyNode* pnode);

// config writer & parser --------------------------------------------
void proxy_node_write_conf (ProxyNode* node, ConfWriter* cw);

// parser ---
void proxy_node_parser_attr (const gchar**  attr_names,
                             const gchar**  attr_values,
                             ProxyNode*     pnode);

#ifdef __cplusplus
}
#endif

#endif  // End of __PROXY_NODE_H

