/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __ROOT_NODE_H
#define __ROOT_NODE_H

#include <urlglib/category_node.h>

#ifdef __cplusplus
extern "C" {
#endif

#define ROOT_NODE(obj)           ((RootNode*)(obj))
#define ROOT_NODE_TAG            "category_store"

typedef struct _RootNode         RootNode;

struct _RootNode {
	BASE_NODE_FIELDS;

	guint  active_max;
	GList* active_list;
	CategoryNode*    category_default;
};

RootNode* root_node_new ();

#define root_node_ref(r)              base_node_ref (BASE_NODE (r))
#define root_node_unref(r)            base_node_unref (BASE_NODE (r))

#define root_node_append(r,c)         base_node_append (BASE_NODE (r), BASE_NODE (c))
#define root_node_prepend(r,c)        base_node_prepend (BASE_NODE (r), BASE_NODE (c))
#define root_node_last_category(r)    (CategoryNode*)base_node_last_child (BASE_NODE (r))
#define root_node_first_category(r)   (CategoryNode*)base_node_first_child (BASE_NODE (r))
#define root_node_nth_category(r,n)   (CategoryNode*)base_node_nth_child (BASE_NODE (r), n)
#define root_node_category_position(r,c)   base_node_child_position (BASE_NODE (r), BASE_NODE (c))

#define root_node_is_active(r)       ((r)->active_list!=NULL)

void root_node_refresh (RootNode* rnode);
void root_node_start_paused (RootNode* rnode);
int  root_node_start (RootNode* rnode);
void root_node_stop (RootNode* rnode);

// config writer & parser --------------------------------------------
void root_node_write_conf (RootNode* rnode, ConfWriter* cw);
void root_node_parser_attr (const gchar**     attr_names,
                            const gchar**     attr_values,
                            RootNode*         rnode);

extern const GMarkupParser root_node_parser;

#ifdef __cplusplus
}
#endif

#endif  // End of __ROOT_NODE_H
