/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __URL_INFO_H
#define __URL_INFO_H

#ifdef __cplusplus
extern "C" {
#endif

// UrlInfo -----------------------------------------------------------
//
// url_info_part ();
// protocol://username:password@address:port/folder/main_filename.ext?query
//
// url_info_part_path ();
// folder/filename.ext  or  folder\filename.ext

typedef struct _UrlInfo   UrlInfo;

struct _UrlInfo {
	const char* protocol;
	int   protocol_len;
	int   location_len;    // length before filename

	const char* id;
	int   id_len;

	const char* password;
	int   password_len;

	const char* address;
	int   address_len;

	const char* port;
	int   port_len;

	const char* path;
	int   path_len;        // path_len = dir_len + filename_len
	int   dir_len;

	const char* filename;  // main_filename     + '.' + ext_filename
	int   filename_len;    // main_filename_len +  1  + ext_filename_len
	int   main_filename_len;

	const char* ext_filename;
	int   ext_filename_len;

	const char* query;
	int   query_len;
};

UrlInfo*  url_info_new (const char* url_str);
UrlInfo*  url_info_new_len (const char* url_str, int len);
UrlInfo*  url_info_new_path (const char* path_str);
UrlInfo*  url_info_new_path_len (const char* path_str, int len);
void      url_info_free (UrlInfo* uli);

//
// url_info_part_len ()
//
// return value : TRUE  - url formation is "protocol://"
//
int   url_info_part_len (UrlInfo* uli, const char* url_str, int len);

#define url_info_part(uli, url_str)    url_info_part_len (uli, url_str, -1)

//
// url_info_part_path_full ()
//
// parse general path.
//
void url_info_part_path_full (UrlInfo* uli, const char* str, int len, int is_url, int need_init);

#define url_info_part_path(uli, path_str)             url_info_part_path_full (uli, path_str, -1, FALSE, TRUE)
#define url_info_part_path_len(uli, path_str, len)    url_info_part_path_full (uli, path_str, len, FALSE, TRUE)

#define url_info_part_url_path(uli, path_str)             url_info_part_path_full (uli, path_str, -1, TRUE, TRUE)
#define url_info_part_url_path_len(uli, path_str, len)    url_info_part_path_full (uli, path_str, len, TRUE, TRUE)

/// Convert a filename from URL
/// &return Returns a newly-created string. This string should be freed with g_free ()
char* url_info_get_filename (UrlInfo* uli);

#ifdef __cplusplus
}
#endif

#endif  // End of __URL_INFO_H

