/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <urlglib/urlglib_signal.h>

static GMemChunk*  signal_mem_chunk = NULL;

static void urlglib_signal_free_1 (gpointer data)
{
	g_mem_chunk_free (signal_mem_chunk, data);
}

void urlglib_signal_list_free (GSList** signal_list)
{
	g_slist_foreach (*signal_list, (GFunc)urlglib_signal_free_1, NULL);
	g_slist_free (*signal_list);
	*signal_list = NULL;
}

UrlglibSignal* urlglib_signal_connect (GSList** signal_list,
                                       UrlglibCallback cb,
                                       gpointer data)
{
	UrlglibSignal* ug_signal;

	if (signal_mem_chunk==NULL) {
		signal_mem_chunk = g_mem_chunk_new ("urlglib_signal_mem_chunk",
		                                    sizeof (UrlglibSignal),
		                                    sizeof (UrlglibSignal) * 8,
		                                    G_ALLOC_AND_FREE);
	}

	ug_signal = g_mem_chunk_alloc (signal_mem_chunk);

	ug_signal->callback = cb;
	ug_signal->data     = data;
	*signal_list = g_slist_prepend (*signal_list, ug_signal);
	return ug_signal;
}

void urlglib_signal_disconnect (GSList** signal_list, UrlglibSignal* ug_signal)
{
	*signal_list = g_slist_remove (*signal_list, ug_signal);
	g_mem_chunk_free (signal_mem_chunk, ug_signal);
}
