/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

/*
 *  Simple notification mechanism for urlglib
 */ 

#ifndef __URLGLIB_SIGNAL_H
#define __URLGLIB_SIGNAL_H

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _UrlglibSignal   UrlglibSignal;
typedef void (*UrlglibCallback) ();

struct _UrlglibSignal {
	UrlglibCallback  callback;
	gpointer         data;
};

UrlglibSignal* urlglib_signal_connect (GSList** signal_list,
                                       UrlglibCallback cb,
                                       gpointer data);

void urlglib_signal_disconnect (GSList** signal_list, UrlglibSignal* ug_signal);
void urlglib_signal_list_free (GSList** signal_list);

#define URLGLIB_SIGNAL_EMIT_BEG(slist, ug_signal)  \
	{                                              \
		GSList* __list_1;                           \
		for (__list_1 = *slist; __list_1; __list_1=__list_1->next) {    \
			ug_signal = (UrlglibSignal*)__list_1->data;

#define URLGLIB_SIGNAL_EMIT_END()  \
		}                          \
	}

#ifdef __cplusplus
}
#endif

#endif  // End of __URLGLIB_SIGNAL_H
