/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __URLGLIB_UTILS_H
#define __URLGLIB_UTILS_H

#define GETTEXT_PACKAGE "urlgfe"
// #include <glib/gi18n-lib.h>
#include <glib.h>
#include <glib/gstdio.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef _WIN32
#define ENABLE_NLS      1
// #define GETTEXT_PACKAGE "urlgfe"
#endif

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

int   test_file_exist_utf8 (const char* path);
char* strndup_no_crlf (const char* str, int len);

void  str_replace_no_crlf (char** dest_pstr, const char* src, int src_len);
void  str_replace (char** dest_pstr, const char* src, int src_len);

// skip ' ', '\r', '\n'
// return next_line
const char* text_get_line_beg (const char* text, char** line, int* line_len);

// string functions -------------------------------------------------

// return : index of next line in string.
// return 0 if no next line.
int  ug_str_next_line (const char* string, int len, int start_offset); 

// return : length of this line in string.
int  ug_str_line_len (const char* string, int len, int start_offset);

// skip space character and return index of string.
int  ug_str_skip_space (const char* string, int len, int start_offset);

// src_length : length of src. if src_length == -1, src is null-terminal string.
void ug_str_replace (char** dest_address, const char* src, int src_length);

// file & directory functions ---------------------------------------

// dir : use UTF-8 encoding.
// len : length of dir. if len == -1, dir is null-terminal string.
gboolean ug_make_dirs (const gchar* dir, gint len);

#ifdef G_OS_WIN32

#ifdef __MINGW32__
#define ug_fopen    g_fopen
#define ug_fseek    fseeko64
#define ug_ftell    ftello64
#else
FILE*  ug_fopen (const gchar *filename, const gchar *mode);
int    ug_fseek (FILE* file, gint64 position, int mode);
gint64 ug_ftell (FILE* file);
#endif

#define ug_unlink   g_unlink
#define ug_rename   g_rename

#else   //  G_OS_WIN32

FILE*   ug_fopen (const gchar *filename, const gchar *mode);
#define ug_fseek    fseek
#define ug_ftell    ftell

int    ug_unlink (const gchar* filename);
int    ug_rename (const gchar* old_filename, const gchar* new_filename);

#endif  // G_OS_WIN32

#ifdef __cplusplus
}
#endif

#endif  // End of __URLGLIB_UTILS_H
