;--------------------------------

; The name of the installer
Name "Urlgfe"

; The file to write
OutFile "urlgfe-1.0.2.exe"

; The default installation directory
InstallDir $PROGRAMFILES\Urlgfe

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\Urlgfe" "Install_Dir"

;--------------------------------

; Pages

Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------

; The stuff to install


Section "Environment check"
  ReadRegStr $0 HKLM "Software\GTK\2.0" Version

  ; StrCmp str1 str2 jump_if_equal [jump_if_not_equal]
  StrCmp $0 "" GtkNotInst GtkInst

  GtkNotInst:
  MessageBox MB_OK|MB_ICONSTOP "GTK+ Runtime Environment version 2.6.x or newer is required to use Urlgfe. You can download it from http://sf.net/projects/gaim/ or http://gimp-win.sf.net/"
  Quit

  GtkInst:
  ; StrCpy var1 var2 len position
  StrCpy $1 $0 2 2
  StrCmp $1 "6." DoReg   ; GTK+ 2.6.x
  StrCmp $1 "7." DoReg   ; GTK+ 2.7.x ...etc
  StrCmp $1 "8." DoReg
  StrCmp $1 "9." DoReg
  StrCmp $1 "10" DoReg
  StrCmp $1 "11" DoReg
  StrCmp $1 "12" DoReg
  StrCmp $1 "13" DoReg
  StrCmp $1 "14" DoReg
  StrCmp $1 "15" DoReg
  StrCmp $1 "16" DoReg
  StrCmp $1 "17" DoReg
  StrCmp $1 "18" DoReg
  StrCmp $1 "19" DoReg
  StrCmp $1 "20" DoReg
  Goto GtkNotInst

  DoReg:
  ReadRegStr $2 HKLM "Software\GTK\2.0" DllPath
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\App Paths\urlgfe.exe" "" "$INSTDIR\urlgfe.exe"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\App Paths\urlgfe.exe" "Path" $2
SectionEnd

Section "Urlgfe main program"

  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File .\urlgfe.exe
  File .\pcre3.dll
  File .\libcurl-4.dll
  File .\libeay32.dll
  File .\libssl32.dll
;  File .\ssleay32.dll
  File .\zlibwapi.dll
  File .\AUTHORS
  File .\ChangeLog
  File .\COPYING
  File .\COPYING.libcurl
  File .\LICENSE.OpenSSL
  File .\NEWS
  File .\README
  File /r .\translation\*.*
  
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\Urlgfe "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Urlgfe" "DisplayName" "Urlgfe"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Urlgfe" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Urlgfe" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Urlgfe" "NoRepair" 1
  WriteUninstaller "uninstall.exe"

SectionEnd ; end the section

; Optional section (can be disabled by the user)
Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\Urlgfe"
  CreateShortCut "$SMPROGRAMS\Urlgfe\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Urlgfe\Urlgfe.lnk" "$INSTDIR\urlgfe.exe" "" "$INSTDIR\urlgfe.exe" 0
  
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Urlgfe"
  DeleteRegKey HKLM SOFTWARE\Urlgfe
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\App Paths\urlgfe.exe"

  ; Remove files and uninstaller
  Delete $INSTDIR\urlgfe.exe
  Delete $INSTDIR\pcre.dll
  Delete $INSTDIR\libcurl.dll
  Delete $INSTDIR\libeay32.dll
  Delete $INSTDIR\libssl32.dll
;  Delete $INSTDIR\ssleay32.dll
  Delete $INSTDIR\zlibwapi.dll
  Delete $INSTDIR\AUTHORS
  Delete $INSTDIR\ChangeLog
  Delete $INSTDIR\COPYING
  Delete $INSTDIR\COPYING.libcurl
  Delete $INSTDIR\LICENSE.OpenSSL
  Delete $INSTDIR\NEWS
  Delete $INSTDIR\README
  Delete $INSTDIR\uninstall.exe

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\Urlgfe\*.*"

  ; Remove directories used
  RMDir "$SMPROGRAMS\Urlgfe"
  RMDir /r "$INSTDIR\locale"
  RMDir "$INSTDIR"

SectionEnd
