/***************************************************************************
                          dcchat.h  -  description
                             -------------------
    begin                : Don Mär 28 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCHAT_H
#define DCCHAT_H

/**
  *@author Mathias Küster
  */

#include <qwidget.h>
#include <qptrlist.h>
#include <qtextedit.h>
#include <qstringlist.h>
#include <qevent.h>

/* for enum eSecureState */
#include <dclib/core/types.h>

#include "DCDialogChat.h"

class DCClient;
class DCQTextEdit;
class QStatusBar;
class QLabel;
class DCShellCommandRunner;
class CMessagePrivateChat;

class DCChat : public DCDialogChat {
Q_OBJECT

public: 
	/** construtor */
	DCChat( QWidget * parent, const char *name, int wflags, DCClient * client, bool bprivate = true );
	/** destructor */
	virtual ~DCChat();

	/** */
	void InitDocument();
	/** */
	DCClient * GetClient() { return m_pClient; };
	/** */
	void SetNick( QString nick, QString hubname );
	/** */
	QString GetNick() { return m_sNick; };
	/** */
	void AddMessage( QString nick, QString message, bool bremote = true, bool forward = false );
	/** */
	void AddMessage( CMessagePrivateChat * msg, bool bremote = true, bool forward = false );
	/** show statusmessage, if show true the settings are ignored */
	void AddStatus( QString message, bool show = false );
	/** */
	void SetCrypt( eSecureState e );

	/** */
	bool close( bool alsoDelete = false );
	/** Made public for auto responder */
	void SendChat( QString message = "" );

protected:
	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** for translation and shell command events */
	virtual void customEvent( QCustomEvent * event );

private:
	/** */
	bool CheckForCommand();
	/** */
	bool CheckForData( QString message );
	/** */
	void NickCompletion();
	/** */
	void QT4TranslationSync();

	/** */
	QString GetTimeStamp();
	/** */
	void AddOutput( QString message );
	/** */
	int FindFirstLink( QString msg );
	/** */
	int ConvertLinks( QString msg, QString & s );
	/** */
	int FindFirstEmoticon( QString msg );
	/** */
	int ConvertEmoticons( QString msg, QString & s );

	/** */
	void AddHistory( QString message );

	/** */
	DCQTextEdit * m_pTextEdit_CHATOUTPUT;
	/** */
	QString m_sLanguage;
	/** */
	bool m_bPrivateChat;
	/** */
	bool m_bSendAway;
	/** */
	DCClient * m_pClient;
	/** */
	QString m_sNick;
	/** */
	QStatusBar * m_pStatusBar;
	/** */
	QLabel * m_pStatusCrypt;
	/** */
	eSecureState m_eSecureState;
	/** */
	QStringList m_lHistory;
	/** last line */
	QString m_sHistoryTempString;
	/** cursor pos */
	int m_nHistoryTempPara;
	/** cursor pos */
	int m_nHistoryTempIndex;
	/** */
	int m_nCurrentHistoryIndex;
	/** */
	QString m_sTimeStamp;
	/** */
	int m_nTabStart;
	/** */
	int m_nTabEnd;
	/** */
	int m_nTabPressed;
	/** */
	QString m_sTabSaved;
	/** */
	QString m_sTabNick;
	/** */
	QWidget * m_pParent;
	/** */
	QString m_sLabel;
	/** list of running shell command threads */
	QPtrList<DCShellCommandRunner> * m_pShellRunners;
	
	/** list of links to handle */
	static const QStringList g_LinkList;
	
public slots:
	/** */
	void slotRightButtonClickedChatOutput( const QPoint& );

private slots:
	/** */
	void slotClickedChatOutput( int, int );
	/** */
	void slotDoubleClickedChatOutput( int, int );
	/** */
	void slotTextChangedChatInput();
	/** */
	void slotSendChat();
	/** */
	void slotBGColorChanged();
};

#endif
