/***************************************************************************
                          dcclient.h  -  description
                             -------------------
    begin                : Thu Oct 4 2001
    copyright            : (C) 2001-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCLIENT_H
#define DCCLIENT_H

/**
  *@author Mathias Küster
  */

#include <qtimer.h>
#include <qlistview.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qmap.h>
#include <qdict.h>
#include <qmutex.h>
#include <qptrqueue.h>

#include "DCDialogClient.h"

#include <dclib/dcobject.h>
#include <dclib/cclient.h>

class DC_UserListItem;

/** */
class DCUserItem {
public:
	/** construtor */
	DCUserItem() {};
	/** destructor */
	~DCUserItem() {};

	/** */
	DC_UserListItem * pItem;
	/** */
	CMessageMyInfo MyInfo;
};

class DCChat;
class QListViewItem;
class QListBoxItem;
class QPopupMenu;
class DC_UserMenuCommand;

class DCClient : public DCDialogClient, public CClient {
Q_OBJECT

public:
	/** construtor */
	DCClient(QWidget* parent, const char *name, int wflags, CString remoteEncoding = CString() );
	/** destructor */
	virtual ~DCClient();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();

	/** chat */
	void DC_Chat( CMessageChat * MessageChat );
	/** myinfo */
	void DC_MyInfo( CMessageMyInfo * MessageMyInfo );
	/** nicklist */
	void DC_NickList( CMessageNickList * MessageNickList );
	/** oplist */
	void DC_OpList( CMessageOpList * MessageOpList );
	/** hello */
	void DC_Hello( CMessageHello * MessageHello );
	/** quit */        	
	void DC_Quit( CMessageQuit * MessageQuit );
	/** */
	void DC_PrivateChat( CMessagePrivateChat * msg, bool bLocal = false );
	/** */
	void DC_PrivateChat( QString nick, QString fromnick, QString message, bool bLocal = false );
	/** usercommand */
	void DC_UserCommand( CMessageUserCommand * MessageUserCommand );

	/** */
	static bool GetOPKickMessage( QString & message, QWidget * parent = 0 );
	/** */
	static bool GetOPForceMoveMessage( QString & message, QString & host, QWidget * parent = 0 );

	/** */
	bool OPKick( QString nick, QString message );
	/** */
	bool OPForceMove( QString nick, QString message, QString host );

	/** */
	void SetNickColor( QString nick, QColor color );
	/** */
	void UpdateStatusBar();

	/** */
	void CloseChat( DCChat * chat );
	/** */
	void CloseAllChats( bool onlyOffline );

	/** callback function */
	virtual int DC_CallBack( CDCMessage * DCMessage );
	/** overridden so that the columns are resized on show() */
	virtual void show();

	/** */
	QString findNick( QString part, uint which );
	
	/** Replaces the %[tag] s in the menu command with their values */
	QString replaceCommandTags( QString & command, QString remotenick );
	
	/** Checks for and sends auto responses */
	void doAutoResponse( QString nick, QString message, DCChat * chatobject );
	
	/** Jump to the nick in the userlist */
	bool jumpToNick( const QString & nick );
	
	/**
	 * Adds all custom (from hub or settings) menu commands to menu.
	 * Returns a map of commands added which are pointers to the
	 * objects stored in DCConfig and must not be deleted.
	 */
	QMap<int, DC_UserMenuCommand*> AddMenuCommands( QPopupMenu * menu, int context );

private:
	/** */
	void addUser( QString nick );
	/** */
	void UpdateCaption();
	/** */
	void SetCrypt( bool b );
	/** */
	void SetConnection( bool b );
	/** */
	void UpdateClientColumn( bool enabled, int index, int width );
	/** Get the list of nicks matching the part, settings read from g_pConfig */
	QStringList matchNicks( const QString & part ) const;
	/** the private chat widgets */
	QMap<QString, DCChat*> m_ChatMap;
	/** */
	CMessageChat m_ChatFloodMessage;
	/** */
	long m_nChatFloodCounter;
	/** */
	bool m_bUserPassword;
	/** the hubchat widget */
	DCChat * m_pHubChat;
	/** */
	bool m_bUseTabWidget;
	/** Nick of last auto response trigger */
	QString lastAutoNick;
	/** Time of last auto response trigger */
	long lastAutoResponseTime;
	/** Last part of a nick for which tab completion requested */
	QString lastPart;
	/** List of nicks matching lastpart */
	QStringList lastMatches;
	/** Regexp to strip [TAGS] from nicks */
	QRegExp stripper;
	/** List of menu commands from the hub */
	QPtrList<DC_UserMenuCommand> hubcommands;

protected:
	/** */
	QMutex m_Mutex;
	/** */
	QTimer m_Timer;
	/** */
	QPtrQueue<CDCMessage> * m_pMessageQueue;
	/** */
	QDict<DCUserItem> m_UserItemDict;

	/** resize the ListView columns */
	void ResizeListViewColumn();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** close event handler */
	virtual void closeEvent( QCloseEvent * closeevent );
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private slots:
	/** */
	void timerDone();
	/** */
	void slotDoubleClickedUserList( QListViewItem * item );
	/** */
	void slotDoubleClickedChatUserList( QListViewItem * item );
	/** */
	void slotRightButtonClickedUserList( QListViewItem *, const QPoint &, int );
	/** */
	void slotDoubleClickedUserChat( QListBoxItem * item );
	/** */
	void slotHubConnect();
	/** */
	void slotSSLInfo();
	/** current tab widget change slot */
	void slotTabWidgetChatCurrentChange(QWidget*);

	void slotSaveColumnWidth(int section, int oldSize, int newSize);
	/** */
	void slotTabCornerCloseWidgetClicked();
};

#endif
