/***************************************************************************
                          dcevent.cpp  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcevent.h"

#include <dclib/dcos.h>
#include <dclib/dcobject.h>
#include <dclib/cdownloadmanager.h>

#include "dcfriendobject.h"

// friend event
/** */
DC_FriendEvent::DC_FriendEvent( DCFriendObject * friendobject ) : QCustomEvent( EVENT_UPDATE_FRIEND )
{
	m_pFriendObject = new DCFriendObject();

	m_pFriendObject->m_sName = friendobject->m_sName;
	m_pFriendObject->m_sDescription = friendobject->m_sDescription;
	m_pFriendObject->m_sHubName = friendobject->m_sHubName;
	m_pFriendObject->m_sHubHost = friendobject->m_sHubHost;
	m_pFriendObject->m_eAwayMode = friendobject->m_eAwayMode;
	m_pFriendObject->m_bPermSlot = friendobject->m_bPermSlot;
}

/** */
DC_FriendEvent::~DC_FriendEvent()
{
	if ( m_pFriendObject )
		delete m_pFriendObject;
}

/** */
DC_DownloadManagerEvent::DC_DownloadManagerEvent( CDownloadManagerInfo * info ) : QCustomEvent( EVENT_UPDATE_DM_STATUSBAR )
{
	m_pDownloadManagerInfo = new CDownloadManagerInfo();

	*m_pDownloadManagerInfo = *info;
}

/** */
DC_DownloadManagerEvent::~DC_DownloadManagerEvent()
{
	delete m_pDownloadManagerInfo;
}

/** */
DC_FileManagerEvent::DC_FileManagerEvent( CFileManagerInfo * info ) : QCustomEvent( EVENT_UPDATE_FM_STATUSBAR )
{
	m_pFileManagerInfo = new CFileManagerInfo();

	*m_pFileManagerInfo = *info;
}

/** */
DC_FileManagerEvent::~DC_FileManagerEvent()
{
	delete m_pFileManagerInfo;
}

/** */
DC_TrafficInfoEvent::DC_TrafficInfoEvent( DCMessageTraffic * info ) : QCustomEvent( EVENT_UPDATE_TR_STATUSBAR )
{
	m_pTrafficInfo = new DCMessageTraffic();

	*m_pTrafficInfo = *info;
}

/** */
DC_TrafficInfoEvent::~DC_TrafficInfoEvent()
{
	delete m_pTrafficInfo;
}
