/***************************************************************************
                          dcevent.h  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCEVENT_H
#define DCEVENT_H

/**
  *@author Mathias Küster
  */

#include <qevent.h>

// user events
#define EVENT_UPDATE_DM_STATUSBAR	QEvent::Type(QEvent::User+1)
#define EVENT_TRANSLATION		QEvent::Type(QEvent::User+2)
#define EVENT_UPDATE_FM_STATUSBAR	QEvent::Type(QEvent::User+3)
#define EVENT_UPDATE_TR_STATUSBAR	QEvent::Type(QEvent::User+4)
#define EVENT_UPDATE_FRIEND		QEvent::Type(QEvent::User+5)
#define EVENT_SHELL_COMMAND_FINISHED	QEvent::Type(QEvent::User+6)
#define EVENT_FILELIST_DECOMPRESSED	QEvent::Type(QEvent::User+7)
#define EVENT_OPEN_FILELIST_FOLDER	QEvent::Type(QEvent::User+8)

class CDownloadManagerInfo;
class CFileManagerInfo;
class DCMessageTraffic;
class DCFriendObject;
class DCShellCommandRunner;
class DCFileBrowserListItem;

// friend event
class DC_FriendEvent : public QCustomEvent {
public:
	/** construtor */
	DC_FriendEvent( DCFriendObject * friendobject );
	/** destructor */
	virtual ~DC_FriendEvent();

	/** */
	DCFriendObject * m_pFriendObject;
};

// dl manager event
class DC_DownloadManagerEvent : public QCustomEvent {
public:
	/** construtor */
	DC_DownloadManagerEvent( CDownloadManagerInfo * info );
	/** destructor */
	virtual ~DC_DownloadManagerEvent();

	/** */
	CDownloadManagerInfo * m_pDownloadManagerInfo;
};

// fm manager event
class DC_FileManagerEvent : public QCustomEvent {
public:
	/** construtor */
	DC_FileManagerEvent( CFileManagerInfo * info );
	/** destructor */
	virtual ~DC_FileManagerEvent();

	/** */
	CFileManagerInfo * m_pFileManagerInfo;
};

// tr manager event
class DC_TrafficInfoEvent : public QCustomEvent {
public:
	/** construtor */
	DC_TrafficInfoEvent( DCMessageTraffic * info );
	/** destructor */
	virtual ~DC_TrafficInfoEvent();

	/** */
	DCMessageTraffic * m_pTrafficInfo;
};

// translator event
class DC_TranslationEvent : public QCustomEvent {
public:
	/** construtor */
	DC_TranslationEvent() : QCustomEvent( EVENT_TRANSLATION ) { };
	/** destructor */
	virtual ~DC_TranslationEvent() {};

	/** */
	bool m_bTranslate;
	/** */
	QString m_sOriginal;
	/** */
	QString m_sTranslation;
	/** */
	QObject * m_pReceiver;
};

// shell command finished event
class DC_ShellCommandFinishedEvent : public QCustomEvent {
public:
	/** constructor */
	DC_ShellCommandFinishedEvent( DCShellCommandRunner * dcscr ) : QCustomEvent( EVENT_SHELL_COMMAND_FINISHED )
	{
		m_pShellCommandRunner = dcscr;
	};
	/** destructor */
	virtual ~DC_ShellCommandFinishedEvent() {};
	
	/** pointer to the shell command runner object */
	DCShellCommandRunner * m_pShellCommandRunner;
};

// .bz2 or .DcLst from disk decompression completed event
class DC_FilelistDecompressedEvent : public QCustomEvent {
public:
	/** constructor */
	DC_FilelistDecompressedEvent ( bool succeeded ) : QCustomEvent( EVENT_FILELIST_DECOMPRESSED )
	{
		ok = succeeded;
	};
	/** destructor */
	virtual ~DC_FilelistDecompressedEvent() {};
	/** */
	bool ok;
};

/* hack to be able to open a folder in the right pane by double clicking it */
class DC_OpenFilelistFolderEvent : public QCustomEvent {
public:
	/** constructor */
	DC_OpenFilelistFolderEvent( DCFileBrowserListItem * item ) : QCustomEvent( EVENT_OPEN_FILELIST_FOLDER )
	{
		m_pItem = item;
	};
	/** destructor */
	virtual ~DC_OpenFilelistFolderEvent() {};
	
	/** The left pane folder item to open */
	DCFileBrowserListItem * m_pItem;
};

#endif
