/***************************************************************************
                          dcfilebrowser.h  -  description
                             -------------------
    begin                : Fre Nov 29 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCFILEBROWSER_H
#define DCFILEBROWSER_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qstringlist.h>

#include <dclib/dcos.h>
#include <dclib/core/cbytearray.h>

#include "DCDialogFileBrowser.h"

class CXml;
class DCFileItem;
class DCFilelistDecompressor;
class QListViewItem;

/**
  *@author Mathias Küster
  */

class DCFileBrowser : public DCDialogFileBrowser  {
Q_OBJECT

public: 
	/** construtor */
	DCFileBrowser( QWidget* parent=0, const char *name=0, int wflags=0, bool AllowOpen = true );
	/** destructor */
	virtual ~DCFileBrowser();

	/** */
	void InitDocument();
	/** */
	void InitTree( QString nick, QString hubname, QString hubhost, QString filename, QString jumpto = QString::null, QStringList dirs = QStringList() );


protected:	
	/** to get filelist decompressed and folder open events */
	virtual void customEvent( QCustomEvent * event );

private:
	/** */
	void ContinueInitTree( CString * data );
	/** */
	void InitTXTTree( QListViewItem * item, CString * data );
	/** */
	void InitXMLTree( QListViewItem * item, CString * data );
	/** */
	void ParseXMLTree( CXml * xml, QListViewItem * item );
	/** */
	bool DownloadDirectory( QString dir );
	/** */
	void JumpTo( QString target );
	/** */
	void CreateMenu( QListViewItem * item, bool direntry, int column );
	/** */
	QString CreateRemotePath( QListViewItem * item );

	/** */
	void DownloadFile( QString rootPath, QString localPath, QString localName,
			   QString remotePath, QString remoteName, ulonglong size,
			   QString hash );
	/** */
	void DownloadPath( QString rootPath, QString localPath, QString localName, QListViewItem * item );

	/** */
	void AddFile( QListViewItem * item, DCFileItem * fileitem );
	/** */
	void AddDirectory( QListViewItem * item, QString name );
	/** */
	void ClearView();
	/** Recursively calculates the size of a folder's contents.
	 *  This is only needed for non-xml filelists.
	 */
	ulonglong CalcDirSize( QListViewItem * item );
	/** Gets the left pane item for the right pane folder item */
	QListViewItem * GetDirItem( QListViewItem * item );
	/** disable all gui elements, while thread running */
	void DisableGuiElements();
	/** enable all gui elements, after thread finished */
	void EnableGuiElements();
	
	/** */
	void GetOwnList();
	
	/** */
	QString m_sNick;
	/** */
	QString m_sHubName;
	/** */
	QString m_sHubHost;
	/** */
	CByteArray m_ListData;
	/** */
	QString m_sFileName;
	/** */
	QString m_sJumpTo;
	/** */
	QStringList m_lDownloadDirs;
	/** */
	ulonglong m_nShareSize;
	/** */
	ulonglong m_nFileCount;
	/** */
	QPixmap m_FolderPixmap;
	/** */
	DCFilelistDecompressor * m_pDecomp;
	/** To disable download for own filelist */
	bool m_bAllowDownload;
	/** Disable the open file button for own file list from options dialog */
	bool m_bAllowOpen;

private slots:
	/** */
	void slotRightButtonClickedDirectory( QListViewItem *, const QPoint &, int );
	/** */
	void slotRightButtonClickedFiles( QListViewItem *, const QPoint &, int );
	/** */
	void slotCurrentChangedDirectory();
	/** */
	void slotExpandedDirectory( QListViewItem * );
	/** */
	void slotCollapsedDirectory( QListViewItem * );
	/** */
	void slotFileOpen();
	/** */
	void slotFileSave();
	/** */
	void slotItemDoubleClicked( QListViewItem *, const QPoint &, int );
	/** find the hub and jump to the user for this filelist */
	void slotGotoUser();
};

#endif
