/***************************************************************************
         dcfilebrowseritems.h  -  Items used by DCFileBrowser
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2002-2004 by Mathias Küster
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCFILEBROWSERITEMS_H
#define DCFILEBROWSERITEMS_H

/**
 * @author Mathias Küster, Edward Sheldrake
 *
 * These are just some things used by DCFileBrowse. They have been moved out
 * of dcfilebrowser.h because other classes do not need to know about them.
 */

#include <qstring.h>
#include <qlistview.h>
#include <qptrlist.h>

// ulonglong
#include <dclib/dcos.h>

#include "ui/dcwidget.h"

class DCFileItem {
public:
	/** construtor */
	DCFileItem() {};
	/** destructor */
	~DCFileItem() {};

	/** */
	QString m_sName;
	/** */
	ulonglong m_nSize;
	/** */
	QString m_sHash;
	/** */
	bool m_bIsDir;
};

/**
 * All the items in the QListView must be DCFileBrowserListItem
 * because compare() does not check the type and just casts
 * the pointer. This is how the class is used in valknut.
 */
class DCFileBrowserListItem : public QListViewItem {
public:
	/** construtor */
	DCFileBrowserListItem( QListView * parent ) : QListViewItem(parent) {
		m_pFileItem = 0;
	};
	/** construtor */
	DCFileBrowserListItem( QListViewItem * parent ) : QListViewItem(parent) {
		m_pFileItem = 0;
	};

	/** destructor */
	virtual ~DCFileBrowserListItem() {};

	/** the faster way to make numeric sort work */
	virtual int compare( QListViewItem * other, int col, bool ascending ) const;

	/** the slower way to make numeric sort work */	
	virtual QString key( int column, bool ascending ) const;

	/** */
	QPtrList<DCFileItem> m_pFileList;
	/** */
	QString m_sName;
	/** Size in bytes of directory contents */
	ulonglong m_nBytes;
	/** Pointer to the DCFileItem that represents this folder */
	DCFileItem * m_pFileItem;
};

/**
 * This is because ListView_DIRECTORY->currentItem() is not reliable.
 * And for sort top. All the items in the QListView must be instances of
 * DC_FBListViewItem because compare() does not check the type, it just
 * casts the pointer. This is how the class is used in valknut.
 */
class DC_FBListViewItem : public DC_QListViewItem {
public:
	/** Constructor with view parent */
	DC_FBListViewItem( QListView * parent ) : DC_QListViewItem( parent ) { pDirItem = 0; };
	/** Constructor with item parent */
	DC_FBListViewItem( QListViewItem * parent ) : DC_QListViewItem ( parent ) { pDirItem = 0; };
	
	/** Destructor */
	virtual ~DC_FBListViewItem() {};
	
	/** re-implemented to use sort top */
	virtual int compare( QListViewItem * i, int col, bool ascending ) const;
	
	/**
	 * If true, this item will be above all items for which m_bSortTop
	 * is false.
	 */
	bool m_bSortTop;
	
	/** The left pane item for this right pane item */
	DCFileBrowserListItem * pDirItem;
};

#endif // DCFILEBROWSERITEMS_H
