/***************************************************************************
     dcfilelistdecompressor.h  -  Valknut Filelist Processing Thread
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCFILELISTDECOMPRESSOR_H
#define DCFILELISTDECOMPRESSOR_H

/**
 * @author Edward Sheldrake
 *
 * This is a QThread that processes a filelist and posts an event when
 * finished which the DCFileBrowser will respond to.
 *
 * It only does the bzip2/he3 decompression, and for old valknut
 * filelists, removes the header and compresses to bzip2.
 *
 * It does not appear possible in QT3 to do any of the XML parsing in
 * this thread.
 */

#include "qthread.h"
#include "qobject.h"

#include <dclib/core/cstring.h>

class CByteArray;

class DCFilelistDecompressor : public QThread {

public:
	/** constructor for decompressing a list from disk */
	DCFilelistDecompressor( QObject * widget, CString filename );
	/** constructor for decompressing our own list from memory */
	DCFilelistDecompressor( QObject * widget, CByteArray * memory );
	/** destructor */
	virtual ~DCFilelistDecompressor();
	
	/** the method that runs in the thread */
	virtual void run();
	
	/** returns the pointer to the decompressed data */
	CString * getData();
	/** */
	CByteArray * recompressed;

private:
	/** */
	bool LoadOldValknutList( CByteArray * dest );
	/** file name */
	CString filename;
	/** decompress from memory */
	CByteArray * compressed;
	/** pointer to the decompressed data */
	CString * data;
	/** the gui to send the finished event to */
	QObject * gui;
};

#endif // DCFILELISTDECOMPRESSOR_H
