/***************************************************************************
                          dcfiletransferinfo.cpp  -  description
                             -------------------
    begin                : Sam Jul 13 2002
    copyright            : (C) 2002-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcfiletransferinfo.h"

#include <qlabel.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <qprogressbar.h>
#include <qfileinfo.h>
#include <qrect.h>

#include <dclib/dcos.h>
#include <dclib/cdownloadqueue.h>

#include "dcconfig.h"
#include "dctransferview.h"
#include "dcguiutils.h"
#include "dciconloader.h"

#include <limits.h>

/** */
DCFileTransferInfo::DCFileTransferInfo( CString filename, QWidget * parent ) : DCDialogFileTransferInfo( parent, "FileTransferInfo", WDestructiveClose )
{
	setIcon( g_pIconLoader->GetPixmap(eiDOWNLOAD) );
	
	QFileInfo fi(QString::fromAscii(filename.Data()));
	setCaption( fi.fileName() + " - " + tr("File Transfer Info") );
	
	m_sFileName = filename;

	InitDocument();

	m_ProgressPixmap.resize(PixmapLabel_CHUNKINFO->size());
	m_ProgressPixmap.fill(Qt::white);
	PixmapLabel_CHUNKINFO->installEventFilter(this);

	connect( &m_Timer, SIGNAL(timeout()), SLOT(timerDone()) );

	m_Timer.start( 0, TRUE );
}

/** */
DCFileTransferInfo::~DCFileTransferInfo()
{
	PixmapLabel_CHUNKINFO->removeEventFilter(this);
	m_Timer.stop();
}

/** */
void DCFileTransferInfo::InitDocument()
{
	DCFileChunkObject * pFileChunk;

	if ( g_pTransferView )
	{
		if ( (pFileChunk=g_pTransferView->DLM_QueueGetFileChunk(m_sFileName)) != 0 )
		{
			LineEdit_FILENAME->setText( pFileChunk->m_sLocalFile.Data() );
			LineEdit_HASH->setText( pFileChunk->m_sHash.Data() );
			
			delete pFileChunk;
		}
	}
}

/** */
void DCFileTransferInfo::timerDone()
{
	if ( g_pTransferView )
	{
		DCFileChunkObject * pFileChunk;
		if ( (pFileChunk=g_pTransferView->DLM_QueueGetFileChunk(m_sFileName)) != 0 )
		{
			LineEdit_FILESIZE->setText( DCGuiUtils::GetSizeString(pFileChunk->m_nSizeDone) +
					" / " + DCGuiUtils::GetSizeString(pFileChunk->m_nSize) );
			LineEdit_SOURCES->setText( QString().setNum(pFileChunk->m_nReferenceCount) );
			
			if ( pFileChunk->m_nSize > (ulonglong) INT_MAX )
			{
				progressBar1->setTotalSteps((int) (pFileChunk->m_nSize/1048576));
				progressBar1->setProgress((int) (pFileChunk->m_nSizeDone/1048576));
			}
			else
			{
				progressBar1->setTotalSteps((int) pFileChunk->m_nSize);
				progressBar1->setProgress((int) pFileChunk->m_nSizeDone);
			}

			int x1,x2;
			DCChunkObject * ChunkObject;
			QPainter pa;
			m_ProgressPixmap.resize(PixmapLabel_CHUNKINFO->size());
			m_ProgressPixmap.fill(Qt::white);
			int width = m_ProgressPixmap.width();
			int area = width * m_ProgressPixmap.height();

			pa.begin(&m_ProgressPixmap);

			if ( pFileChunk->m_nSize != 0 )
			{
				ChunkObject = 0;

				while( (ChunkObject=pFileChunk->m_Chunks.Next(ChunkObject)) != 0 )
				{
					if ( ChunkObject->m_eChunkState == ecsFREE )
						pa.setPen( Qt::red );
					else
						pa.setPen( Qt::green );

					x1 = (ChunkObject->m_nStart*area/pFileChunk->m_nSize);
        				x2 = (ChunkObject->m_nEnd*area/pFileChunk->m_nSize);

					int ys,xs,ye,xe,y;

					xs = x1%width;
					ys = (x1-xs)/width;
					xe = x2%width;
					ye = (x2-xe)/width;

					// printf("%d %d %d %d\n",xs,xe,ys,ye);

					for(y=ys;y<=ye;y++)
					{
						if( (y==ys) && (y==ye) )
							pa.drawLine( xs, y, xe, y );
						else if ( y==ys )
							pa.drawLine( xs, y, width, y );
						else if ( y==ye )
							pa.drawLine( 0, y, xe, y );
						else
							pa.drawLine( 0, y, width, y );
					}
				}
			}
			
			delete pFileChunk;

			pa.end();

			bitBlt( PixmapLabel_CHUNKINFO, 0, 0, &m_ProgressPixmap, 0, 0, m_ProgressPixmap.width(), m_ProgressPixmap.height(), Qt::CopyROP );
		}
	}

	m_Timer.start( 5000, TRUE );
}

/** */
bool DCFileTransferInfo::eventFilter( QObject * object, QEvent * event )
{
	if ( object == PixmapLabel_CHUNKINFO )
	{
		if ( event->type() == QEvent::Paint )
		{
			QRect rect = ((QPaintEvent*)event)->rect();
			
			bitBlt( PixmapLabel_CHUNKINFO, rect.x(), rect.y(), &m_ProgressPixmap, rect.x(), rect.y(), rect.width(), rect.height(), Qt::CopyROP );
		}
		else if ( event->type() == QEvent::Resize )
		{
			/*
			 * Scaling a QPixmap in QT3 looks slow.
			 * So just make a new one.
			 */
			timerDone();
		}
	}
	
	return DCDialogFileTransferInfo::eventFilter( object, event );
}
