/***************************************************************************
         dcfriendobject.h  -  Friend Object used by Friends list
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2002 by François Gannaz
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

#ifndef DCFRIENDOBJECT_H
#define DCFRIENDOBJECT_H

/**
  *@author François Gannaz, Edward Sheldrake
  *
  * This object was moved out of dcuserslist.h to reduce dependencies
  * between various files - DCConfig and DCEvent only need to know about this,
  * not about the DCUsersList.
  */

#include <qstring.h>
#include <qmap.h>

// for away mode
#include <dclib/core/types.h>

class QListViewItem;

class DCFriendObject {
public:
	/** construtor */
	DCFriendObject() {
		m_pItem      = 0;
		m_eAwayMode  = euamOFFLINE;
		m_bAutoSec   = false;
		m_bSendImage = false;
		m_bPermSlot  = false;
		m_bIgnore    = false;
	};
	/** destructor */
	~DCFriendObject() {};

	QListViewItem * m_pItem;

	/** */
	QString m_sName;
	/** */
	QString m_sDescription;
	/** */
	QString m_sHubName;
	/** */
	QString m_sHubHost;
	/** */
	QString m_sImageFileName;
	/** */
	eUserAwayMode m_eAwayMode;
	/** */
	bool m_bAutoSec;
	/** */
	bool m_bSendImage;
	/** If true, grant this user a permanent slot */
	bool m_bPermSlot;
	/** If true, ignore main chat lines from this user */
	bool m_bIgnore;
};

typedef QMap<QString, DCFriendObject*> FriendMap;

#endif // DCFRIENDOBJECT_H
