/***************************************************************************
                          dcgui.cpp  -  description
                             -------------------
    begin                : Mon Okt  1 19:59:45 CEST 2001
    copyright            : (C) 2001-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcgui.h"

// Qt includes
#include <qapplication.h>
#include <qaction.h>
#include <qaccel.h>
#include <qcombobox.h>
#include <qdockwindow.h>
#include <qtextedit.h>
#include <qtooltip.h>
#include <qfile.h>
#include <qlabel.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qstatusbar.h>
#include <qtoolbar.h>
#include <qwhatsthis.h>
#include <qworkspace.h>

// application specific includes
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif

#include "dcoptions.h"
#include "dchublistmanager.h"
#include "dcconnectionmanager.h"
#include "dctransferview.h"
#include "dcconfig.h"
#include "dchubsearch.h"
#include "dcspy.h"
#include "dcuserslist.h"
#include "dctranslator.h"
#include "dcevent.h"
#include "dcpluginmanager.h"
#include "dcmenuhandler.h"
#include "dciconloader.h"
#include "dcguiutils.h"

#include "DCDialogAbout.h"
#include "ui/DCDialogDebugSettings.h"

#include "trayicon.h"

#include <dclib/dcos.h>
#include <dclib/dcobject.h>
#include <dclib/cdownloadmanager.h>
#include <dclib/cfilemanager.h>
#include <dclib/csearchmanager.h>
#include <dclib/cutils.h>
#include <dclib/core/cdir.h>
#include <dclib/dclib.h>
#include <dclib/core/csocket.h>

#include "ui/dcqlabel.h"

#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

/** */
DCGuiApp::DCGuiApp()
{
	StringMap * map;
	StringMap * tabBarMap;
	int width,height;
	bool b;

	m_bTransferViewGotTrayed = false;
	m_bIsQuitPromptVisible = false;

	g_pTransferView      = 0;
	g_pHubListManager    = 0;
	g_pConnectionManager = 0;
	g_pSpy               = 0;
	g_pUsersList         = 0;

	setCaption( tr("Valknut") + QString(" ") + QString(VERSION) );

	// set default icon
	setIcon( g_pIconLoader->GetPixmap(eiICON_22x22) );

	SetTheme();

	///////////////////////////////////////////////////////////////////
	// call inits to invoke all other construction parts
	initView();
	initActions();
	initMenuBar();
	initToolBar();
	initStatusBar();
	initTray();

	connect( g_pConfig, SIGNAL(defaultDownloadModeChanged()), this, SLOT(slotDefaultDownloadModeChanged()) );

	if ( !(g_pConfig->GetBackgroundPixmap().isEmpty()) )
	{
		QPixmap bp;
		if ( bp.load(g_pConfig->GetBackgroundPixmap()) )
			pWorkspace->setPaletteBackgroundPixmap(bp);
	}

	g_pConfig->GetAppGeometry( width, height );
	resize( width, height );

	b = true;

	// init transferview
	if ( g_pConfig->GetMap("TRANSFERVIEW",map) )
	{
		if ( (*map)["DOCKED"].toInt() == 0 )
		{
			b = false;
		}
	}

	if ( b )
	{
		pTransferViewDock->dock();

		if ( ((*map)["HEIGHT"].toInt() != 0) &&
		     ((*map)["WIDTH"].toInt() != 0) )
		{
			pTransferViewDock->setFixedExtentHeight((*map)["HEIGHT"].toInt());
			pTransferViewDock->setFixedExtentWidth((*map)["WIDTH"].toInt());
		}
		
		bool nl = true;
		if ( (*map)["NL"] == "FALSE" )
		{
			nl = false;
		}
		moveDockWindow( pTransferViewDock, Qt::Dock((*map)["DOCK"].toInt()), nl, (*map)["INDEX"].toInt(), (*map)["EXTRAOFFSET"].toInt() );
	}
	else
	{
		pTransferViewDock->undock();

		if ( ((*map)["HEIGHT"].toInt() != 0) &&
		     ((*map)["WIDTH"].toInt() != 0) )
		{
			pTransferViewDock->resize( (*map)["WIDTH"].toInt(), (*map)["HEIGHT"].toInt() );
		}
	}

	viewTabBar->setOn(true);
	viewToolBar->setOn(true);
	viewStatusBar->setOn(true);
	
	m_bWasMaximized = false;

	// init main window
	if ( g_pConfig->GetMap("MAINVIEW",map) )
	{
		if ( (*map)["MAXIMIZED"].toInt() == 1 )
		{
			m_bWasMaximized = true;
		}
		else
		{
			m_bWasMaximized = false;
		}

		if ( (*map)["DOCKED"].toInt() == 0 )
		{
			fileToolbar->undock();
		}
		else
		{
			fileToolbar->dock();

			moveDockWindow( fileToolbar, Qt::Dock((*map)["DOCK"].toInt()) );
		}
	}

	if ( g_pConfig->GetTabBar() == false )
		viewTabBar->toggle();
	if ( g_pConfig->GetToolBar() == false )
		viewToolBar->toggle();
	if ( g_pConfig->GetStatusBar() == false )
		viewStatusBar->toggle();
	if ( g_pConfig->GetShowTransferWin() )
	{
		pTransferViewDock->show();
	}
	else
	{
		pTransferViewDock->hide();
		pTransferViewDock->setEnabled(false);
	}

	// restore tabbar position and state
	if ( g_pConfig->GetMap("TABBAR",tabBarMap) )
	{
		int x = (*tabBarMap)["X"].toInt();
		int y = (*tabBarMap)["Y"].toInt();
		int w = (*tabBarMap)["WIDTH"].toInt();
		int h = (*tabBarMap)["HEIGHT"].toInt();
		
		if ( (*tabBarMap)["DOCKED"].toInt() == 0 )
		{
			windowsTabBar->undock();
			
			if ( (w != 0) && (h != 0) )
			{
				windowsTabBar->resize(w,h);
			}
		
			windowsTabBar->move(x,y);
		}
		else
		{
			windowsTabBar->dock();
			
			bool nl = true;
			if ( (*tabBarMap)["NL"] == "FALSE" )
			{
				nl = false;
			}
			
			moveDockWindow( windowsTabBar, Qt::Dock((*tabBarMap)["DOCK"].toInt()), nl, (*tabBarMap)["INDEX"].toInt(), (*tabBarMap)["EXTRAOFFSET"].toInt() );
			
			/* if ( (w != 0) && (h != 0) )
			{
				windowsTabBar->setFixedExtentWidth(w);
				windowsTabBar->setFixedExtentHeight(h);
			} */
		}
	}

	g_pTranslator = new DCTranslator();

	// install event filter on qApp ;-)
	qApp->installEventFilter(&m_ApplicationEvents);

	// init timer
	m_pTimer = new QTimer();

	connect( m_pTimer, SIGNAL(timeout()), this, SLOT(slotTimeout()) );

	// start timer
	m_pTimer->start( 1000 );
}

/** */
DCGuiApp::~DCGuiApp()
{
	deinitActions();

	// remove event-filter from appl.
	qApp->removeEventFilter(&m_ApplicationEvents);

	// stop timer
	m_pTimer->stop();
	delete m_pTimer;

	deinitTray();

	deinitView();

	delete g_pTranslator;
	g_pTranslator = 0;
}

/** */
void DCGuiApp::initActions()
{
	fileOptions = new QAction(this);
	fileOptions->setText(tr("Options"));
	fileOptions->setMenuText(tr("&Options"));
	fileOptions->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiCONFIGURE), g_pIconLoader->GetPixmap(eiCONFIGURE_22x22) ) );
	fileOptions->setAccel( QAccel::stringToKey(tr("Ctrl+O")) );
	fileOptions->setStatusTip(tr("Open options dialog"));
	fileOptions->setWhatsThis(tr("Open options dialog\n\nOpens a dialog where settings can be changed."));
	connect(fileOptions, SIGNAL(activated()), this, SLOT(slotFileOptions()));

	fileFileListBrowser = new QAction(this);
	fileFileListBrowser->setText(tr("Filelist browser"));
	fileFileListBrowser->setMenuText(tr("Filelist browser"));
	fileFileListBrowser->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiVIEW_SIDETREE) ) );
	fileFileListBrowser->setStatusTip(tr("Open filelist browser"));
	fileFileListBrowser->setWhatsThis(tr("Open filelist browser\n\nOpen an empty filelist browser that you can use to open filelists from disk."));
	connect(fileFileListBrowser, SIGNAL(activated()), this, SLOT(slotFileFileListBrowser()));

	fileFileListBrowserLocal = new QAction(this);
	fileFileListBrowserLocal->setText(tr("Filelist browser local"));
	fileFileListBrowserLocal->setMenuText(tr("Filelist browser local"));
	fileFileListBrowserLocal->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiVIEW_SIDETREE) ) );
	fileFileListBrowserLocal->setStatusTip(tr("Open local filelist browser"));
	fileFileListBrowserLocal->setWhatsThis(tr("Open local filelist browser\n\nView the files in your own share."));
	connect(fileFileListBrowserLocal, SIGNAL(activated()), this, SLOT(slotFileFileListBrowserLocal()));

	fileFileListRefresh = new QAction(this);
	fileFileListRefresh->setText(tr("Refresh share"));
	fileFileListRefresh->setMenuText(tr("Refresh share"));
	fileFileListRefresh->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiRELOAD), g_pIconLoader->GetPixmap(eiRELOAD_22x22) ) );
	fileFileListRefresh->setStatusTip(tr("Refresh share"));
	fileFileListRefresh->setWhatsThis(tr("Refresh share\n\nUpdate your share to match file changes on disk."));
	connect( fileFileListRefresh, SIGNAL(activated()), this, SLOT(slotFileCreateShare()) );

	fileQuickOptions = new QAction(this);
	fileQuickOptions->setText(tr("Quick Options"));
	fileQuickOptions->setMenuText(tr("Quick options"));
	fileQuickOptions->setAccel( QAccel::stringToKey(tr("F12")) );
	fileQuickOptions->setStatusTip(tr("Select default download mode"));
	connect(fileQuickOptions, SIGNAL(activated()), this, SLOT(slotFileQuickOptions()));

	/** Default download mode */
	fileDefaultDldAsk = new QAction(this);
	fileDefaultDldAsk->setText(tr("Download mode: Ask"));
	fileDefaultDldAsk->setMenuText(tr("Download mode: Ask"));
	fileDefaultDldAsk->setStatusTip(tr("Set default download mode to: Ask"));
	fileDefaultDldAsk->setWhatsThis(tr("Download mode: Ask\n\nPrompt for single or multi source mode when starting a download."));
	fileDefaultDldAsk->setToggleAction(true);
	fileDefaultDldSingle = new QAction(this);
	fileDefaultDldSingle->setText(tr("Download mode: Single"));
	fileDefaultDldSingle->setMenuText(tr("Download mode: Single"));
	fileDefaultDldSingle->setStatusTip(tr("Set default download mode to: Single"));
	fileDefaultDldSingle->setWhatsThis(tr("Download mode: Single\n\nEach file will be downloaded from a single user without using chunked downloading."));
	fileDefaultDldSingle->setToggleAction(true);
	fileDefaultDldMulti = new QAction(this);
	fileDefaultDldMulti->setText(tr("Download mode: Multi"));
	fileDefaultDldMulti->setMenuText(tr("Download mode: Multi"));
	fileDefaultDldMulti->setStatusTip(tr("Set default download mode to: Multi"));
	fileDefaultDldMulti->setWhatsThis(tr("Download mode: Multi\n\nEach file will be downloaded in multiple chunks possibly from different users."));
	fileDefaultDldMulti->setToggleAction(true);
	fileDefaultDldGroup = new QActionGroup( this, "Download type", true );
        connect( fileDefaultDldGroup, SIGNAL( selected(QAction*) ), this, SLOT(slotChangeDefaultDldMode(QAction*)) );
	fileDefaultDldGroup->add(fileDefaultDldAsk);
	fileDefaultDldGroup->add(fileDefaultDldSingle);
	fileDefaultDldGroup->add(fileDefaultDldMulti);

	slotDefaultDownloadModeChanged();

	fileReloadPlugins = new QAction(this);
	fileReloadPlugins->setText(tr("Reload Plugins"));
	fileReloadPlugins->setMenuText(tr("&Reload Plugins"));
	fileReloadPlugins->setStatusTip(tr("Reload Plugins"));
	fileReloadPlugins->setWhatsThis(tr("Reload Plugins\n\nScan for new and reload any add-on software."));
	connect(fileReloadPlugins, SIGNAL(activated()), this, SLOT(slotFileReloadPlugins()));

	fileQuit = new QAction(this);
	fileQuit->setText(tr("Exit"));
	fileQuit->setMenuText(tr("Exit"));
	fileQuit->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiEXIT) ) );
	fileQuit->setAccel( QAccel::stringToKey(tr("Ctrl+Q")) );
	fileQuit->setStatusTip(tr("Quits the application"));
	fileQuit->setWhatsThis(tr("Exit\n\nQuits the application."));
	connect(fileQuit, SIGNAL(activated()), this, SLOT(slotFileQuit()));

	viewTabBar = new QAction(this);
	viewTabBar->setText(tr("Tabbar"));
	viewTabBar->setMenuText(tr("Tabbar"));
	viewTabBar->setToggleAction(true);
	viewTabBar->setStatusTip(tr("Enables/disables the tabbar"));
	viewTabBar->setWhatsThis(tr("Tabbar\n\nEnables/disables the tabbar. The tabbar shows a tab for each hub window."));
	connect(viewTabBar, SIGNAL(toggled(bool)), this, SLOT(slotViewTabBar(bool)));
	
	viewToolBar = new QAction(this);
	viewToolBar->setText(tr("Toolbar"));
	viewToolBar->setMenuText(tr("Tool&bar"));
	viewToolBar->setToggleAction(true);
	viewToolBar->setStatusTip(tr("Enables/disables the toolbar"));
	viewToolBar->setWhatsThis(tr("Toolbar\n\nEnables/disables the toolbar."));
	connect(viewToolBar, SIGNAL(toggled(bool)), this, SLOT(slotViewToolBar(bool)));

	viewStatusBar = new QAction(this);
	viewStatusBar->setText(tr("Statusbar"));
	viewStatusBar->setMenuText(tr("&Statusbar"));
	viewStatusBar->setToggleAction(true);
	viewStatusBar->setStatusTip(tr("Enables/disables the statusbar"));
	viewStatusBar->setWhatsThis(tr("Statusbar\n\nEnables/disables the statusbar."));
	connect(viewStatusBar, SIGNAL(toggled(bool)), this, SLOT(slotViewStatusBar(bool)));

	viewTrayIcon = new QAction(this);
	viewTrayIcon->setText(tr("System Tray Icon"));
	viewTrayIcon->setMenuText(tr("System Tray Icon"));
	viewTrayIcon->setToggleAction(true);
	viewTrayIcon->setStatusTip(tr("Enables/disables the system tray icon"));
	viewTrayIcon->setWhatsThis(tr("System Tray Icon\n\nAdds or removes an icon in the system tray area."));
	viewTrayIcon->setOn(g_pConfig->GetEnableTray());
	connect( viewTrayIcon, SIGNAL(toggled(bool)), this, SLOT(slotViewTrayIcon(bool)) );

	viewDock = new QAction(this);
	viewDock->setText(tr("Dock"));
	viewDock->setMenuText(tr("&Dock"));
	viewDock->setStatusTip(tr("Dock the application"));
	viewDock->setWhatsThis(tr("Dock\n\nDock the application. Only the system tray icon will be visible."));
	viewDock->setEnabled(g_pConfig->GetEnableTray());
	connect(viewDock, SIGNAL(activated()), this, SLOT(slotViewDock()));

	/* FIXME remove when QT3 translations are no longer copied over to QT4 */
	if ( false )
	{
		const QString qt4_s1 = tr("View mode");
		const QString qt4_s2 = tr("Windows");
		const QString qt4_s3 = tr("Tabs");
	}

	windowCascade = new QAction(this);
	windowCascade->setText(tr("Cascade"));
	windowCascade->setMenuText(tr("&Cascade"));
	windowCascade->setStatusTip(tr("Cascades all windows"));
	windowCascade->setWhatsThis(tr("Cascade\n\nCascades all windows."));
	connect(windowCascade, SIGNAL(activated()), pWorkspace, SLOT(cascade()));

	windowTile = new QAction(this);
	windowTile->setText(tr("Tile Vertically"));
	windowTile->setMenuText(tr("&Tile Vertically"));
	windowTile->setStatusTip(tr("Tiles all windows vertically"));
	windowTile->setWhatsThis(tr("Tile Vertically\n\nTiles all windows vertically."));
	connect(windowTile, SIGNAL(activated()), this, SLOT(tileVertically()));

	windowTileHor = new QAction(this);
	windowTileHor->setText(tr("Tile &Horizontally"));
	windowTileHor->setMenuText(tr("Tile &Horizontally"));
	windowTileHor->setStatusTip(tr("Tiles all windows horizontally."));
	windowTileHor->setWhatsThis(tr("Tile Horizontally\n\nTiles all windows horizontally."));
	connect(windowTileHor, SIGNAL(activated()), pWorkspace, SLOT(tile()));

	windowMinimize = new QAction(this);
	windowMinimize->setText(tr("Minimize"));
	windowMinimize->setMenuText(tr("&Minimize"));
	windowMinimize->setStatusTip(tr("Minimize all windows."));
	windowMinimize->setWhatsThis(tr("Minimize\n\nMinimize all windows."));
	connect(windowMinimize, SIGNAL(activated()), this, SLOT(slotWindowMinimize()));

	windowCloseHubs = new QAction(this);
	windowCloseHubs->setText(tr("Close disconnected hubs"));
	windowCloseHubs->setMenuText(tr("Close disconnected hubs"));
	windowCloseHubs->setStatusTip(tr("Close all disconnected hub windows."));
	windowCloseHubs->setWhatsThis(tr("Close disconnected hubs\n\nClose all disconnected hub windows."));
	connect(windowCloseHubs, SIGNAL(activated()), this, SLOT(slotWindowCloseHubs()));

	windowCloseAllChats = new QAction(this);
	windowCloseAllChats->setText(tr("Close all chat windows"));
	windowCloseAllChats->setMenuText(tr("Close all chat windows"));
	windowCloseAllChats->setStatusTip(tr("Close all chat windows."));
	windowCloseAllChats->setWhatsThis(tr("Close all chat windows\n\nClose all chat windows."));
	connect(windowCloseAllChats, SIGNAL(activated()), this, SLOT(slotWindowCloseAllChats()));

	windowCloseOfflineChats = new QAction(this);
	windowCloseOfflineChats->setText(tr("Close all offline chat windows"));
	windowCloseOfflineChats->setStatusTip(tr("Close all offline chat windows."));
	windowCloseOfflineChats->setWhatsThis(tr("Close all offline chat windows\n\nClose all chat windows where the user is no longer on the hub."));
	connect( windowCloseOfflineChats, SIGNAL(activated()), this, SLOT(slotWindowCloseOfflineChats()) );
	
	windowCloseFilelists = new QAction(this);
	windowCloseFilelists->setText(tr("Close all filelist windows"));
	windowCloseFilelists->setStatusTip(tr("Close all filelist windows."));
	windowCloseFilelists->setWhatsThis(tr("Close all filelist windows\n\nClose all filelist browsers."));
	connect( windowCloseFilelists, SIGNAL(activated()), this, SLOT(slotWindowCloseFilelists()) );

	windowCloseSearches = new QAction(this);
	windowCloseSearches->setText(tr("Close all search windows"));
	windowCloseSearches->setStatusTip(tr("Close all search windows."));
	windowCloseSearches->setWhatsThis(tr("Close all search windows\n\nClose all search windows."));
	connect( windowCloseSearches, SIGNAL(activated()), this, SLOT(slotWindowCloseSearches()) );

	windowAction = new QActionGroup(this, 0, false);
	windowAction->insert(windowCascade);
	windowAction->insert(windowTile);
	windowAction->insert(windowTileHor);
	windowAction->insert(windowMinimize);
	windowAction->insert(windowCloseHubs);
	windowAction->insert(windowCloseAllChats);
	windowAction->insert(windowCloseOfflineChats);
	windowAction->insert(windowCloseFilelists);
	windowAction->insert(windowCloseSearches);

	/** server list */
	actionServerList = new QAction(this);
	actionServerList->setText(tr("Hub List"));
	actionServerList->setMenuText(tr("H&ub List"));
	actionServerList->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiSERVER) ) );
	actionServerList->setAccel( QAccel::stringToKey(tr("Ctrl+U")) );
	actionServerList->setStatusTip(tr("Show Hub List."));
	actionServerList->setWhatsThis(tr("Hub List\n\nShows the lists of public and bookmarks hubs."));
	connect(actionServerList, SIGNAL(activated()), this, SLOT(slotActionServerList()));

	/** tranfer list */
	actionTransferList = new QAction(this);
	actionTransferList->setText(tr("Transfer List"));
	actionTransferList->setMenuText(tr("&Transfer List"));
	actionTransferList->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiTRANSFER) ) );
	actionTransferList->setAccel( QAccel::stringToKey(tr("Ctrl+T")) );
	actionTransferList->setStatusTip(tr("Show Transfer List."));
	actionServerList->setWhatsThis(tr("Hub List\n\nShows the lists of public and bookmarks hubs."));
	connect(actionTransferList, SIGNAL(activated()), this, SLOT(slotActionTransferList()));

	/** hub search */
	actionHubSearch = new QAction(this);
	actionHubSearch->setText(tr("Hub Search"));
	actionHubSearch->setMenuText(tr("Hub &Search"));
	actionHubSearch->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiFIND), g_pIconLoader->GetPixmap(eiFIND_22x22) ) );
	actionHubSearch->setAccel( QAccel::stringToKey(tr("Ctrl+S")) );
	actionHubSearch->setStatusTip(tr("Open Hub Search."));
	actionHubSearch->setWhatsThis(tr("Hub Search\n\nOpens a search window where you can search for files."));
	connect(actionHubSearch, SIGNAL(activated()), this, SLOT(slotActionHubSearch()));

	/** spy */
	actionSpy = new QAction(this);
	actionSpy->setText(tr("Spy"));
	actionSpy->setMenuText(tr("S&py"));
	actionSpy->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiSPY) ) );
	actionSpy->setAccel( QAccel::stringToKey(tr("Ctrl+P")) );
	actionSpy->setStatusTip(tr("Show Search Spy."));
	actionSpy->setWhatsThis(tr("Spy\n\nThe search spy shows incoming searches and search statistics."));
	connect(actionSpy, SIGNAL(activated()), this, SLOT(slotActionSpy()));

	/** users */
	actionUsers = new QAction(this);
	actionUsers->setText(tr("Users"));
	actionUsers->setMenuText(tr("Users"));
	actionUsers->setIconSet( QIconSet( g_pIconLoader->GetPixmap(eiUSERS), g_pIconLoader->GetPixmap(eiUSERS_22x22) ) );
	actionUsers->setAccel( QAccel::stringToKey(tr("Ctrl+F")) );
	actionUsers->setStatusTip(tr("Show Users List."));
	actionUsers->setWhatsThis(tr("Users\n\nList of favorite users, showing if they are online."));
	connect(actionUsers, SIGNAL(activated()), this, SLOT(slotActionUsers()));

	/** actiongroup for away mode */
	actionGroupAwayMode = new QActionGroup( this );
        actionGroupAwayMode->setExclusive( true );

	/** away mode normal */
	actionAwayModeNormal = new QAction(this);
	actionAwayModeNormal->setText(tr("Normal"));
	actionAwayModeNormal->setMenuText(tr("&Normal"));
	actionAwayModeNormal->setAccel( QAccel::stringToKey(tr("Ctrl+N")) );
	actionAwayModeNormal->setStatusTip(tr("Set away mode to normal"));
	actionAwayModeNormal->setWhatsThis(tr("Away mode: normal\n\nNormal mode, away message will not be sent automatically."));
	actionAwayModeNormal->setToggleAction(true);
	actionAwayModeNormal->setOn(true);

	/** away mode away */
	actionAwayModeAway = new QAction(this);
	actionAwayModeAway->setText(tr("Away"));
	actionAwayModeAway->setMenuText(tr("&Away"));
	actionAwayModeAway->setAccel( QAccel::stringToKey(tr("Ctrl+A")) );
	actionAwayModeAway->setStatusTip(tr("Set away mode to away."));
	actionAwayModeAway->setWhatsThis(tr("Away mode: normal\n\nYou will be marked as away and your away message will be sent in response to a new private message."));
	actionAwayModeAway->setToggleAction(true);

	actionGroupAwayMode->add(actionAwayModeNormal);
	actionGroupAwayMode->add(actionAwayModeAway);

        connect( actionGroupAwayMode, SIGNAL( selected( QAction* ) ), this, SLOT( slotChangeAwayMode() ) );

	helpAboutApp = new QAction(this);
	helpAboutApp->setText(tr("About"));
	helpAboutApp->setMenuText(tr("&About..."));
	helpAboutApp->setStatusTip(tr("About the application."));
	helpAboutApp->setWhatsThis(tr("About\n\nAbout the application. Displays version, copyright and licensing information."));
	connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));

	helpManualApp = new QAction(this);
	helpManualApp->setText(tr("Manual"));
	helpManualApp->setMenuText(tr("&Manual..."));
	helpManualApp->setStatusTip(tr("Online User Manual."));
	helpManualApp->setWhatsThis(tr("Manual\n\nOnline User Manual. Launches the configured web browser."));
	connect(helpManualApp, SIGNAL(activated()), this, SLOT(slotHelpManual()));

	helpSupportApp = new QAction(this);
	helpSupportApp->setText(tr("Support"));
	helpSupportApp->setMenuText(tr("&Support..."));
	helpSupportApp->setStatusTip(tr("Connect to Valknut hub"));
	helpSupportApp->setWhatsThis(tr("Support\n\nConnect to the Valknut hub."));
	connect(helpSupportApp, SIGNAL(activated()), this, SLOT(slotHelpSupport()));

	debugSettings = new QAction(this);
	debugSettings->setText(tr("Debug Settings..."));
	debugSettings->setStatusTip(tr("Settings for debugging"));
	debugSettings->setWhatsThis(tr("Debug Settings\n\nChange settings useful for debugging."));
	connect( debugSettings, SIGNAL(activated()), this, SLOT(slotDebugSettings()) );
}

/** */
void DCGuiApp::deinitActions()
{
	delete fileOptions;
	delete fileFileListBrowser;
	delete fileFileListBrowserLocal;
	delete fileFileListRefresh;
	delete fileQuickOptions;
	delete fileDefaultDldAsk;
	delete fileDefaultDldSingle;
	delete fileDefaultDldMulti;
	delete fileDefaultDldGroup;
	delete fileReloadPlugins;
	delete fileQuit;

	delete viewTabBar;
	delete viewToolBar;
	delete viewStatusBar;
	delete viewTrayIcon;
	delete viewDock;

	delete windowCascade;
	delete windowTile;
	delete windowTileHor;
	delete windowMinimize;
	delete windowCloseHubs;
	delete windowCloseAllChats;
	delete windowCloseOfflineChats;
	delete windowCloseFilelists;
	delete windowCloseSearches;
	delete windowAction;

	delete actionServerList;
	delete actionTransferList;
	delete actionHubSearch;
	delete actionSpy;
	delete actionUsers;
	delete actionAwayModeNormal;
	delete actionAwayModeAway;
	delete actionGroupAwayMode;

	delete helpAboutApp;
	delete helpManualApp;
	delete helpSupportApp;
	
	delete debugSettings;
}

/** */
void DCGuiApp::initMenuBar()
{
	///////////////////////////////////////////////////////////////////
	// MENUBAR

	///////////////////////////////////////////////////////////////////
	// menuBar entry pFileMenu
	pFileMenu=new QPopupMenu();
	fileOptions->addTo(pFileMenu);
	pQuickOptionsMenu=new QPopupMenu();
	fileDefaultDldGroup->addTo(pQuickOptionsMenu);
	pFileMenu->insertItem(tr("Quick Options"),pQuickOptionsMenu);
	pFileMenu->insertSeparator();
	fileFileListBrowser->addTo(pFileMenu);
	fileFileListBrowserLocal->addTo(pFileMenu);
	pFileMenu->insertSeparator();
	fileFileListRefresh->addTo(pFileMenu);
	pFileMenu->insertSeparator();
	fileReloadPlugins->addTo(pFileMenu);
	pFileMenu->insertSeparator();
	fileQuit->addTo(pFileMenu);

	///////////////////////////////////////////////////////////////////
	// menuBar entry viewMenu
	pViewMenu=new QPopupMenu();
	pViewMenu->setCheckable(true);
	viewTabBar->addTo(pViewMenu);
	viewToolBar->addTo(pViewMenu);
	viewStatusBar->addTo(pViewMenu);
	viewTrayIcon->addTo(pViewMenu);
	viewDock->addTo(pViewMenu);

	///////////////////////////////////////////////////////////////////
	// menuBar awayMenu
	pAwayMenu=new QPopupMenu();
	actionAwayModeNormal->addTo(pAwayMenu);
	actionAwayModeAway->addTo(pAwayMenu);

	///////////////////////////////////////////////////////////////////
	// menuBar actionMenu
	pActionMenu=new QPopupMenu();
	actionServerList->addTo(pActionMenu);
	actionTransferList->addTo(pActionMenu);
	actionHubSearch->addTo(pActionMenu);
	actionSpy->addTo(pActionMenu);
	actionUsers->addTo(pActionMenu);
	pActionMenu->insertSeparator();
	pActionMenu->insertItem(tr("Away &Mode"),pAwayMenu);

	///////////////////////////////////////////////////////////////////
	// menuBar entry windowMenu
	pWindowMenu = new QPopupMenu(this);
	pWindowMenu->setCheckable(true);
	connect(pWindowMenu, SIGNAL(aboutToShow()), this, SLOT(windowMenuAboutToShow()));

	///////////////////////////////////////////////////////////////////
	// menuBar entry helpMenu
	pHelpMenu=new QPopupMenu();
	helpAboutApp->addTo(pHelpMenu);
	pHelpMenu->insertSeparator();
	helpManualApp->addTo(pHelpMenu);
	pHelpMenu->insertSeparator();
	helpSupportApp->addTo(pHelpMenu);
	pHelpMenu->insertSeparator();
	debugSettings->addTo(pHelpMenu);
	pHelpMenu->insertSeparator();
	pHelpMenu->insertItem(tr("What's &This"), this, SLOT(whatsThis()), SHIFT+Key_F1);

	menuBar()->insertItem(tr("&File"), pFileMenu);
	menuBar()->insertItem(tr("&View"), pViewMenu);
	menuBar()->insertItem(tr("&Action"), pActionMenu);
	menuBar()->insertItem(tr("&Window"), pWindowMenu);
	menuBar()->insertItem(tr("&Help"), pHelpMenu);
}

/** */
void DCGuiApp::initToolBar()
{
	///////////////////////////////////////////////////////////////////
	// TOOLBAR
	fileToolbar = new QToolBar(this, tr("Action"));
	fileToolbar->setLabel(tr("Toolbar"));

	QWhatsThis::whatsThisButton(fileToolbar);
	fileToolbar->addSeparator();
	fileOptions->addTo(fileToolbar);
	fileToolbar->addSeparator();
	actionServerList->addTo(fileToolbar);
	actionHubSearch->addTo(fileToolbar);
	actionTransferList->addTo(fileToolbar);
	actionSpy->addTo(fileToolbar);
	actionUsers->addTo(fileToolbar);
	fileToolbar->addSeparator();
	fileFileListRefresh->addTo(fileToolbar);

	// ADD USERS HERE
	fileToolbar->addSeparator();
	
	windowsTabBar = new QToolBar(this, tr("Tab Bar"));
	windowsTabBar->setLabel(tr("Tab Bar"));
	
	// init tabbar
	g_pConnectionManager->InitTabBar(windowsTabBar);
}

/** */
void DCGuiApp::initStatusBar()
{
	///////////////////////////////////////////////////////////////////
	//STATUSBAR
	statusBar()->message(tr("Ready."));

	statusDMLabel = new QLabel(statusBar(),"Label");
	statusDMLabel->setFrameShape( QFrame::NoFrame );
	statusDMLabel->setFrameShadow( QFrame::Plain );
	statusBar()->addWidget(statusDMLabel,0,true);

	statusTRLabel = new DCQLabel(statusBar(),"Label");
	statusTRLabel->setFrameShape( QFrame::NoFrame );
	statusTRLabel->setFrameShadow( QFrame::Plain );
	statusBar()->addWidget(statusTRLabel,0,true);
	QToolTip::add( statusTRLabel, tr("RX/TX Traffic.") );

	statusDSLabel = new QLabel(statusBar(),"Label");
	statusDSLabel->setFrameShape( QFrame::NoFrame );
	statusDSLabel->setFrameShadow( QFrame::Plain );
	statusBar()->addWidget(statusDSLabel,0,true);
	QToolTip::add( statusDSLabel, tr("Available disc space.") );

	statusFMLabel = new QLabel(statusBar(),"Label");
	statusFMLabel->setFrameShape( QFrame::NoFrame );
	statusFMLabel->setFrameShadow( QFrame::Plain );
	statusBar()->addWidget(statusFMLabel,0,true);
	statusFMLabel->hide();

	connect( statusTRLabel, SIGNAL(contextMenuRequested()), this, SLOT(slotContextMenuTraffic()) );
}

/** */
void DCGuiApp::initView()
{
	pWorkspace = new QWorkspace( this );
	setCentralWidget(pWorkspace);
	pWorkspace->showMaximized();
	
	setDockMenuEnabled(false);

	// create connection manager view
	CConnectionManager::SetInstance(new DCConnectionManager(pWorkspace,"DCConnectionManager"));

	// create hublist manager view
	CHubListManager::SetInstance(new DCHubListManager(pWorkspace,"HubListManager"));
	g_pHubListManager->hide();
	g_pHubListManager->setEnabled(false);

	// create dock window for transfer view
	pTransferViewDock = new QDockWindow( QDockWindow::InDock, this );
	pTransferViewDock->setCaption(tr("Transfer List"));
	pTransferViewDock->setResizeEnabled(true);
	moveDockWindow(pTransferViewDock,Qt::DockBottom);
	pTransferViewDock->hide();

	// create transfer view
	CDownloadManager::SetInstance(new DCTransferView(pTransferViewDock,"TransferView"));

	pTransferViewDock->setWidget(g_pTransferView);

	// create spy view
	new DCSpy(pWorkspace,"SearchSpy");
	g_pSpy->hide();
	g_pSpy->setEnabled(false);

	// create users view
	new DCUsersList(pWorkspace,"FriendsList");
	g_pUsersList->hide();
	g_pUsersList->setEnabled(false);

/*	if ( g_pConfig->GetMode() == ecmACTIVE )
	{
		CString error;
		if ( g_pTransferView->DLM_InitListen(error) == false )
		{
			QString s;
			s = error.Data();

			if ( s.isEmpty() )
				s = tr("(no error message from socket)");
			else
				s = "(" + s + ")";

			QMessageBox::critical( 0, "Valknut",
			tr("TCP listen failed, change to passive mode! ") + s );

			g_pConfig->SetMode(ecmPASSIVE);
		}
	}
	*/
}

/** */
void DCGuiApp::deinitView()
{
	if ( pTransferViewDock )
	{
		removeDockWindow(pTransferViewDock);
	}

	if ( g_pTransferView )
	{
		delete g_pTransferView;
	}
	
	if ( pTransferViewDock )
	{
		delete pTransferViewDock;
		pTransferViewDock = 0;
	}
	
	if ( g_pHubListManager )
	{
		delete g_pHubListManager;
	}
	
	if ( g_pSpy )
	{
		delete g_pSpy;
	}
	
	if ( g_pUsersList )
	{
		delete g_pUsersList;
	}
	
	if ( g_pConnectionManager )
	{
		delete g_pConnectionManager;
	}
}

/** setup all windows */
void DCGuiApp::initWindows()
{
	////////////////////////////////////////////////////////////////////
	StringMap * map;

	// setup hubview
	g_pConfig->GetMap("HUBVIEW",map);

	if ( (*map)["VISIBLE"].toInt() == 1 )
	{
		g_pHubListManager->setEnabled(true);

		if ( (*map)["MAXIMIZED"].toInt() == 1 )
		{
			g_pHubListManager->showMaximized();
		}
		else
		{
			g_pHubListManager->show();
		}
	}
	else if ( (*map)["MINIMIZED"].toInt() == 1 )
	{
		g_pHubListManager->showMinimized();

		if ( (*map)["ENABLED"].toInt() == 0 )
			g_pHubListManager->hide();
		else
			g_pHubListManager->setEnabled(true);
	}

	// setup spyview
	g_pConfig->GetMap("SPYVIEW",map);

	if ( (*map)["VISIBLE"].toInt() == 1 )
	{
		g_pSpy->setEnabled(true);

		if ( (*map)["MAXIMIZED"].toInt() == 1 )
		{
			g_pSpy->showMaximized();
		}
		else
		{
			g_pSpy->show();
		}
	}
	else if ( (*map)["MINIMIZED"].toInt() == 1 )
	{
		g_pSpy->showMinimized();

		if ( (*map)["ENABLED"].toInt() == 0 )
			g_pSpy->hide();
		else
			g_pSpy->setEnabled(true);
	}

	// setup userview
	g_pConfig->GetMap("USERVIEW",map);

	if ( (*map)["VISIBLE"].toInt() == 1 )
	{
		g_pUsersList->setEnabled(true);

		if ( (*map)["MAXIMIZED"].toInt() == 1 )
		{
			g_pUsersList->showMaximized();
		}
		else
		{
			g_pUsersList->show();
		}
	}
	else if ( (*map)["MINIMIZED"].toInt() == 1 )
	{
		g_pUsersList->showMinimized();

		if ( (*map)["ENABLED"].toInt() == 0 )
			g_pUsersList->hide();
		else
			g_pUsersList->setEnabled(true);
	}
}

/** initialize the tray icon */
void DCGuiApp::initTray()
{
	m_pTrayIcon = 0;
	m_bTray	= false;

	if ( g_pConfig->GetEnableTray() )
	{
		m_bEnableTray = true;
		m_pTrayIcon = new TrayIcon();
		m_pTrayIcon->setIcon( g_pIconLoader->GetPixmap(eiICON_22x22) );

		m_pTrayIcon->show();

		connect( m_pTrayIcon, SIGNAL(clicked( const QPoint&, int )), this, SLOT(slotTrayMenu( const QPoint&, int )) );
	}
	else
	{
		m_bEnableTray = false;
	}
}

/** deinitialize the tray icon */
void DCGuiApp::deinitTray()
{
	if ( m_pTrayIcon )
	{
		disconnect( m_pTrayIcon, SIGNAL(clicked( const QPoint&, int )), this, SLOT(slotTrayMenu( const QPoint&, int )) );
		
		m_pTrayIcon->hide();
		delete m_pTrayIcon;
		m_pTrayIcon = 0;
		
		m_bEnableTray = false;
	}
}

/** */
bool DCGuiApp::queryExit()
{
	if ( m_bIsQuitPromptVisible == false )
	{
		m_bIsQuitPromptVisible = true;
		int exit = QMessageBox::question(this, tr("Quit..."),
				tr("Do you really want to quit?"),
				QMessageBox::Ok, QMessageBox::Cancel);
		m_bIsQuitPromptVisible = false;
	
		return (exit==QMessageBox::Ok);
	}
	else
	{
		// never get here, m_bIsQuitPromptVisible is checked at event processing
		printf("Already asking to quit.\n");
		return false;
	}
}

/** */
void DCGuiApp::slotTimeout()
{
	if ( g_pConfig->GetAutoAwayMode() )
	{
		// check for user input
		if ( m_ApplicationEvents.m_nNoUserInputTimer == 0 )
		{
			// check away mode and reset to normal
			if ( g_pConfig->GetAwayMode() != euamNORMAL )
			{
				actionAwayModeNormal->setOn(true);
			}

			m_ApplicationEvents.m_nNoUserInputTimer = time(0);
		}
		else
		{
			// away timeout
			if ( (time(0)-m_ApplicationEvents.m_nNoUserInputTimer) >= g_pConfig->GetAutoAwayTime() )
			{
				// check away mode
				if ( g_pConfig->GetAwayMode() == euamNORMAL )
				{
					actionAwayModeAway->setOn(true);
				}

				m_ApplicationEvents.m_nNoUserInputTimer = time(0);
			}
		}
	}

	showFreeDiscSpace();
	
	if ( m_pTrayIcon && !m_bEnableTray )
	{
		viewTrayIcon->setOn(false);
	}
}

/** */
void DCGuiApp::showFreeDiscSpace()
{
	CString s = g_pConfig->GetDownloadFolder();
	ulonglong n = 0;
	
	if ( s.NotEmpty() )
	{
		if ( CDir::FreeDiscSpace( s, &n ) == false )
		{
			n = 0;
		}
	}
	
	statusDSLabel->setText(DCGuiUtils::GetSizeString(n));
}

/** */
void DCGuiApp::closeEvent( QCloseEvent * event )
{
	if ( m_bIsQuitPromptVisible == false )
	{
		if ( slotFileQuit() == false )
		{
			event->ignore();
		}
		else
		{
			event->accept();
		}
	}
	else
	{
		// TODO find a way to raise the window on the user's desktop
		event->ignore();
	}
}

/** */
void DCGuiApp::customEvent( QCustomEvent * event )
{
	if ( event->type() == EVENT_UPDATE_DM_STATUSBAR )
	{
		DC_DownloadManagerEvent * e = (DC_DownloadManagerEvent*)event;

		QString s = "SL: ";
		s += QString().setNum(e->m_pDownloadManagerInfo->slot_use_settings);
		s += '/';
		s += QString().setNum(e->m_pDownloadManagerInfo->slot_max);
		s += ' ';
		s += QString().setNum(e->m_pDownloadManagerInfo->slot_use_rate_extra);
		s += '/';
		if ( g_pConfig->GetExtraSlotsRate() > 0 )
		{
			s += QString().setNum(g_pConfig->GetMaxExtraSlots());
		}
		else
		{
			s += '0';
		}
		s += ' ';
		s += QString().setNum(e->m_pDownloadManagerInfo->slot_use_operator);
		s += '/';
		s += QString().setNum(e->m_pDownloadManagerInfo->slot_use_user);
		s += '/';
		s += QString().setNum(e->m_pDownloadManagerInfo->slot_use_special);

		s += " UL: ";
		s += CUtils::GetTransferString(e->m_pDownloadManagerInfo->Rate()).Data();
		s += " DL: ";
		s += CUtils::GetTransferString(e->m_pDownloadManagerInfo->rate_dl).Data();

		statusDMLabel->setText(s);

		// set trayicon tooltip
		if ( m_pTrayIcon )
		{
			QString tt = tr("Connected to ");
			tt += QString().setNum(g_pConnectionManager->GetConnectedHubCount());
			tt += ' ';
			tt += tr("hubs");
			tt += '\n';
			tt += s;
			tt += '\n';
			tt += statusTRLabel->text();
			m_pTrayIcon->setToolTip( tt );
		}
	}
	else if ( event->type() == EVENT_UPDATE_FM_STATUSBAR )
	{
		DC_FileManagerEvent * e = (DC_FileManagerEvent*)event;

		QString s;

		switch(e->m_pFileManagerInfo->m_eFileManagerStatus)
		{
			case efmsCREATESHARELIST:
				s = "L ";
				break;
			case efmsCREATESEARCHINDEX:
				s = "S ";
				break;
			case efmsCREATEHASHLIST:
				s = "H ";
				break;
			case efmsNONE:
				statusFMLabel->hide();
				statusBar()->message(tr("Refresh share finished."));
				break;
			default:
				break;
		}
		
		if ( !s.isEmpty() )
		{
			s += QString().setNum(e->m_pFileManagerInfo->m_nProgress,'f',2);
			s += "%";
			statusFMLabel->setText(s);
			statusFMLabel->show();
		}
	}
	else if ( event->type() == EVENT_UPDATE_TR_STATUSBAR )
	{
		DC_TrafficInfoEvent * e = (DC_TrafficInfoEvent*)event;

		QString s = "RX: ";
		s += DCGuiUtils::GetSizeString(e->m_pTrafficInfo->m_nRx);
		s += " TX: ";
		s += DCGuiUtils::GetSizeString(e->m_pTrafficInfo->m_nTx);

		statusTRLabel->setText(s);

		// set trayicon tooltip
		if ( m_pTrayIcon )
		{
			QString tt = tr("Connected to ");
			tt += QString().setNum(g_pConnectionManager->GetConnectedHubCount());
			tt += ' ';
			tt += tr("hubs");
			tt += '\n';
			tt += statusDMLabel->text();
			tt += '\n';
			tt += s;
			m_pTrayIcon->setToolTip( tt );
		}
	}
	else
	{
		QMainWindow::customEvent( event );
	}
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

/** */
void DCGuiApp::tileVertically()
{
	int i,count =0;
	int y = 0;
	int heightForEach;

	// primitive horizontal tiling
	QWidgetList windows = pWorkspace->windowList();
	if ( !windows.count() )
		return;

	for ( i = 0; i < int(windows.count()); ++i )
	{
		if ( windows.at(i)->isEnabled() )
			count++;
	}

	if ( count > 0 )
	{
		heightForEach = pWorkspace->height() / count;

		for ( i = 0; i < int(windows.count()); ++i )
		{
			if ( !windows.at(i)->isEnabled() )
				continue;
			QWidget *window = windows.at(i);
			if ( (window->testWState( WState_Maximized )) || (window->isMinimized()))
			{
				// prevent flicker
				window->hide();
				window->showNormal();
			}

			int preferredHeight = window->minimumHeight()+window->parentWidget()->baseSize().height();
			int actHeight = QMAX(heightForEach, preferredHeight);

			window->parentWidget()->setGeometry( 0, y, pWorkspace->width(), actHeight );
			y += actHeight;
		}
	}
}

/** minimize all windows */
void DCGuiApp::slotWindowMinimize()
{
	uint i;

	for ( i = 0; i < pWorkspace->windowList().count(); i++ )
	{
		if ( pWorkspace->windowList().at(i)->isVisible() )
			pWorkspace->windowList().at(i)->showMinimized();
	}
}

/** close all chat windows */
void DCGuiApp::slotWindowCloseAllChats()
{
	g_pConnectionManager->CloseAllChats(false);
}

/** */
void DCGuiApp::slotWindowCloseOfflineChats()
{
	g_pConnectionManager->CloseAllChats(true);
}

/** close all chat windows */
void DCGuiApp::slotWindowCloseHubs()
{
	g_pConnectionManager->CloseDisconnectedHubs();
}

/** */
void DCGuiApp::slotWindowCloseFilelists()
{
	closeWindowsOfClass("DCFileBrowser");
}

/** */
void DCGuiApp::slotWindowCloseSearches()
{
	closeWindowsOfClass("DCHubSearch");
}

/** */
void DCGuiApp::slotFileOptions()
{
	DCOptions * od;

	statusBar()->message(tr("Open options dialog..."));

	od = new DCOptions(this);

	od->SetValues();

	if ( QDialog::Accepted == od->exec() )
	{
		// move values to dcconfig
		od->GetValues();
		// save values
		g_pConfig->Save();
		// update connected servers
                g_pConnectionManager->SendMyInfoToConnectedServers();
	}

	/*
	 * set theme only if it has changed, or reset theme if a different one was tested
	 * also set theme if one theme was tested, but the old theme then saved
	 * but no need to set the theme if it was set with the test button
	 * od->GetTestedTheme() == old value of g_pConfig->GetTheme() if test button not pressed
	 */
	if ( od->GetTestedTheme() != g_pConfig->GetTheme() )
	{
		SetTheme();
	}
	
	delete od;

	statusBar()->message(tr("Ready."));
}

/** */
void DCGuiApp::slotFileFileListBrowser()
{
	g_pTransferView->NewFileBrowser(QString::null,QString::null,QString::null,QString::null);
}

/** */
void DCGuiApp::slotFileFileListBrowserLocal()
{
	g_pTransferView->NewLocalFileBrowser(false);
}

/** */
void DCGuiApp::slotFileReloadPlugins()
{
	g_pPluginManager->DeInitPlugins();
	g_pPluginManager->Load();
}

/** */
void DCGuiApp::slotFileQuickOptions()
{
	pQuickOptionsMenu->exec(QCursor::pos());
}

/** */
void DCGuiApp::slotChangeDefaultDldMode(QAction* DldType)
{
	DldType->setOn(true);
	if (fileDefaultDldAsk->isOn())
	{
		g_pConfig->SetDefaultDownloadMode(0);
	}
	else if (fileDefaultDldSingle->isOn())
	{
		g_pConfig->SetDefaultDownloadMode(1);
	}
	else  if (fileDefaultDldMulti->isOn())
	{
		g_pConfig->SetDefaultDownloadMode(2);
	}
}

/** */
void DCGuiApp::slotFileCreateShare()
{
	QString s;

	if ( CFileManager::Instance()->CreateShareList() )
		s = tr("Refresh share in progress.");
	else
		s = tr("Refresh share already in progress.");

	statusBar()->message(s);
}

/** */
bool DCGuiApp::slotFileQuit()
{
	StringMap * map;
	StringMap * tabBarMap;

	statusBar()->message(tr("Exiting application..."));

	if ( g_pConfig->GetQueryOnExit() )
	{
		if ( queryExit() == false )
		{
			statusBar()->message(tr("Exiting application... aborted"));
			return false;
		}
	}

	// shutdown all transfers
	g_pTransferView->DLM_Shutdown();
	// stop running searches
	CSearchManager::Instance()->StopSearch();
	// close all clients
	g_pConnectionManager->DisconnectAllClients();

	while( (g_pTransferView->DLM_ShutdownState() != essSHUTDOWNREADY) ||
	       (CSearchManager::Instance()->IsSearch()) ||
	       (g_pConnectionManager->GetConnectedHubCount() > 0) )
	{
		qApp->processEvents();
#ifdef WIN32
		Sleep(100);
#else
		usleep(100);
#endif
	}

	// close all hub windows
	g_pConnectionManager->CloseDisconnectedHubs();

	g_pConfig->SetTabBar(viewTabBar->isOn());
	g_pConfig->SetToolBar(viewToolBar->isOn());
	g_pConfig->SetStatusBar(viewStatusBar->isOn());
	g_pConfig->SetAppGeometry( width(), height() );

	// save transfer view settings
	g_pConfig->GetMap("TRANSFERVIEW",map);

	(*map)["X"]      = QString().setNum(pTransferViewDock->x());
	(*map)["Y"]      = QString().setNum(pTransferViewDock->y());
	(*map)["WIDTH"]  = QString().setNum(pTransferViewDock->width());
	(*map)["HEIGHT"] = QString().setNum(pTransferViewDock->height());
	(*map)["DOCKED"] = QString().setNum((pTransferViewDock->area()!=0));
	
	Qt::Dock dock3;
	int index3;
	bool nl3;
	int extraOffset3;
	if ( getLocation( pTransferViewDock, dock3, index3, nl3, extraOffset3 ) )
	{
		(*map)["DOCK"] = QString().setNum(dock3);
		
		QString nlstring;
		if ( nl3 )
		{
			nlstring = "TRUE";
		}
		else
		{
			nlstring = "FALSE";
		}
		
		(*map)["NL"] = nlstring;
		(*map)["INDEX"] = QString().setNum(index3);
		(*map)["EXTRAOFFSET"] = QString().setNum(extraOffset3);
	}	

	// save tabbar position and state
	g_pConfig->GetMap("TABBAR", tabBarMap);
	(*tabBarMap)["X"]	= QString().setNum(windowsTabBar->x());
	(*tabBarMap)["Y"]	= QString().setNum(windowsTabBar->y());
	(*tabBarMap)["WIDTH"]	= QString().setNum(windowsTabBar->width());
	(*tabBarMap)["HEIGHT"]	= QString().setNum(windowsTabBar->height());
	(*tabBarMap)["DOCKED"]	= QString().setNum((windowsTabBar->area()!=0));

	g_pConfig->SetShowTransferWin( pTransferViewDock->isVisible() );

	// save transfer list settings
	g_pTransferView->DeInitDocument();

	// save hub list settings
	g_pHubListManager->DeInitDocument();

	// save spy view settings
	g_pSpy->DeInitDocument();

	// save user view settings
	g_pUsersList->DeInitDocument();

	// init main window
	g_pConfig->GetMap("MAINVIEW",map);
	(*map)["MAXIMIZED"] = QString().setNum(isMaximized());
	(*map)["DOCKED"]    = QString().setNum((fileToolbar->area()!=0));

	Qt::Dock dock;
	int index;
	bool nl;
	int  extraOffset;

	if ( getLocation( fileToolbar, dock, index, nl, extraOffset ) )
	{
		(*map)["DOCK"] = QString().setNum(dock);
	}
	
	Qt::Dock dock2;
	int index2;
	bool nl2;
	int extraOffset2;
	
	if ( getLocation( windowsTabBar, dock2, index2, nl2, extraOffset2 ) )
	{
		(*tabBarMap)["DOCK"] = QString().setNum(dock2);
		
		QString nlstring;
		if ( nl2 )
		{
			nlstring = "TRUE";
		}
		else
		{
			nlstring = "FALSE";
		}
		
		(*tabBarMap)["NL"] = nlstring;
		(*tabBarMap)["INDEX"] = QString().setNum(index2);
		(*tabBarMap)["EXTRAOFFSET"] = QString().setNum(extraOffset2);
	}

	// save gui config
	g_pConfig->SaveDCGui();

	m_pTimer->stop();

	qApp->quit();

	statusBar()->message(tr("Ready."));

	return true;
}

/** */
void DCGuiApp::slotViewTabBar(bool toggle)
{
	statusBar()->message(tr("Toggle tabbar..."));
	///////////////////////////////////////////////////////////////////
	// turn Toolbar on or off
	if (toggle== false)
	{
		windowsTabBar->hide();
	}
	else
	{
		windowsTabBar->show();
	}

	statusBar()->message(tr("Ready."));
}

/** */
void DCGuiApp::slotViewToolBar(bool toggle)
{
	statusBar()->message(tr("Toggle toolbar..."));
	///////////////////////////////////////////////////////////////////
	// turn Toolbar on or off
	if (toggle== false)
	{
		fileToolbar->hide();
	}
	else
	{
		fileToolbar->show();
	}

	statusBar()->message(tr("Ready."));
}

/** */
void DCGuiApp::slotViewStatusBar(bool toggle)
{
	statusBar()->message(tr("Toggle statusbar..."));
	///////////////////////////////////////////////////////////////////
	//turn Statusbar on or off

	if (toggle == false)
	{
		statusBar()->hide();
	}
	else
	{
		statusBar()->show();
	}

	statusBar()->message(tr("Ready."));
}

/** dock the application */
void DCGuiApp::slotViewDock()
{
	if ( !m_pTrayIcon )
	{
		QMessageBox::information(this, tr("Dock Application"), tr("The system tray icon must be enabled to dock the application."));
		return;
	}
	
	statusBar()->message(tr("Dock/Undock application..."));
	///////////////////////////////////////////////////////////////////
	//dock/undock the application

	if ( m_bTray )
	{
		if ( m_bWasMaximized )
		{
			showMaximized();
		}
		else
		{
			show();
		}
		// show dcgui in front of any applications after undock
		raise();
		// restore desktop position
		move(m_DesktopPosition);
		
		// restore transferview settings
		if ( m_bTransferViewGotTrayed )
		{
			pTransferViewDock->show();
		}

		m_bTray = false;
	}
	else
	{
		if ( isMinimized() )
		{
			showNormal();
		}
		else
		{
			// save old desktop position
			m_DesktopPosition = pos();
			// save old maximized status
			m_bWasMaximized = isMaximized();
			
			if ( pTransferViewDock->isVisible() && pTransferViewDock->area() == 0 )
			{
				m_bTransferViewGotTrayed = true;
				pTransferViewDock->hide();
			}
			else
			{
				m_bTransferViewGotTrayed = false;
			}
			
			// hide application
			hide();
		
			m_bTray = true;
		}
	}

	statusBar()->message(tr("Ready."));
}

/** */
void DCGuiApp::slotHelpAbout()
{
	QString s;
	DCDialogAbout * dlg;
	ulonglong up = CSocket::m_Traffic.GetTraffic(ettTX);
	ulonglong down = CSocket::m_Traffic.GetTraffic(ettRX);
	double ratio = 0;
	
	if ( down > 0 )
	{
		ratio = (double) up / (double) down;
	}
	
	dlg = new DCDialogAbout(this);
	
	s  = dlg->TextLabel2->text();
	
	s += "\n\n";
	s += tr("Valknut ");
	s += VERSION;
	s += " (";
	s += VALKNUT_BUILD_INFO;
	s += ")\n";
	s += tr("Using dclib ");
	s += dclibVersion();
	s += " (";
	s += dclibBuildInfo();
	s += ")\n";
	s += tr("Using QT(R) ");
	s += qVersion();
	
	s += "\n\n";
	s += tr("Ratio: Overall: ");
	s += QString().setNum( ratio, 'f', 2 );
	s += tr(" (Up: ");
	s += DCGuiUtils::GetSizeString( up );
	s += tr(", Down: ");
	s += DCGuiUtils::GetSizeString( down );
	s += tr(")\nThis session: ");
	
	up -= g_pConfig->GetStartUploaded();
	down -= g_pConfig->GetStartDownloaded();
	
	if ( down > 0 )
	{
		ratio = (double) up / (double) down;
	}
	else
	{
		ratio = 0;
	}
	
	s += QString().setNum( ratio, 'f', 2 );
	s += tr(" (Up: ");
	s += DCGuiUtils::GetSizeString( up );
	s += tr(", Down: ");
	s += DCGuiUtils::GetSizeString( down );
	s += ")";

	dlg->TextLabel_VERSION->setText( QString("Valknut ") + QString(VERSION) );
	dlg->PixmapLabel_ICON->setPixmap( g_pIconLoader->GetPixmap(eiGLOBE) );
	
	dlg->TextLabel2->setText( s );

/* not usually done but is allowed, including a file in the middle of a function */
#include "about.h"
	dlg->TextEdit_AUTHORS->append(g_sAboutAuthors);
	dlg->TextEdit_AUTHORS->setCursorPosition(0,0);

	// load license file
	QFile f(g_pConfig->GetValknutDataPath() + DIRSEPARATOR + "COPYING");
	
	if ( f.open(IO_ReadOnly) )
	{
		QTextStream t( &f );
		t.setEncoding(QTextStream::UnicodeUTF8);
		dlg->TextEdit_LICENSE->setText( t.read() );
	}
	else
	{
		dlg->TextEdit_LICENSE->append(tr("Warning license file not found !"));
	}
	
	dlg->exec();

	delete dlg;
}

/** open the online manual in web browser */
void DCGuiApp::slotHelpManual()
{
	g_pConfig->OpenURL("http://wxdcgui.sourceforge.net/doc/manual.html");
}

/** connect to the valknut hub */
void DCGuiApp::slotHelpSupport()
{
	// TODO: Check to see if we are already connected or not.
	g_pConnectionManager->Connect(CString(),"valknut.dyndns.info:59176");
}

/** change user away mode */
void DCGuiApp::slotChangeAwayMode()
{
	switch(g_pConfig->GetAwayMode())
	{
		case euamAWAY:
			actionAwayModeNormal->setOn(true);
			g_pConfig->SetAwayMode(euamNORMAL);
			break;
		default:
			actionAwayModeAway->setOn(true);
			g_pConfig->SetAwayMode(euamAWAY);
			break;
	}

	g_pConnectionManager->SendMyInfoToConnectedServers();
}

/** */
void DCGuiApp::windowMenuAboutToShow()
{
	int c;

	pWindowMenu->clear();
	windowCascade->addTo(pWindowMenu);
	windowTile->addTo(pWindowMenu);
	windowTileHor->addTo(pWindowMenu);
	windowMinimize->addTo(pWindowMenu);
	pWindowMenu->insertSeparator();
	windowCloseHubs->addTo(pWindowMenu);
	windowCloseAllChats->addTo(pWindowMenu);
	windowCloseOfflineChats->addTo(pWindowMenu);
	windowCloseFilelists->addTo(pWindowMenu);
	windowCloseSearches->addTo(pWindowMenu);
	
	if ( pWorkspace->windowList().isEmpty() )
	{
		windowAction->setEnabled(false);
	}
	else
	{
		windowAction->setEnabled(true);
	}

	pWindowMenu->insertSeparator();

	QWidgetList windows = pWorkspace->windowList();

	c = 0;

	for ( int i = 0; i < int(windows.count()); ++i )
	{
		if ( windows.at(i)->isEnabled() )
		{
			int id = pWindowMenu->insertItem(QString("&%1 ").arg(c+1)+windows.at(i)->caption(), this, SLOT( windowMenuActivated( int ) ) );
			pWindowMenu->setItemParameter( id, i );
			pWindowMenu->setItemChecked( id, pWorkspace->activeWindow() == windows.at(i) );
			c++;
		}
	}

	if ( c == 0 )
	{
		windowAction->setEnabled(false);
	}
}

/** */
void DCGuiApp::windowMenuActivated( int id )
{
	QWidget* w = pWorkspace->windowList().at( id );
	if ( w )
	{
		w->show();
		w->setFocus();
	}
}

/** show/hide transfer list window */
void DCGuiApp::slotActionTransferList()
{
	statusBar()->message(tr("Show/hide transfer list window ..."));

	if ( g_pTransferView != 0 )
	{
		if ( g_pTransferView->isVisible() )
		{
			pTransferViewDock->setEnabled(false);
			pTransferViewDock->hide();
		}
		else
		{
			pTransferViewDock->setEnabled(true);
			pTransferViewDock->show();
		}
	}

	statusBar()->message(tr("Ready."));
}

/** show/hide mdi widget */
void DCGuiApp::showMDIWidget( QWidget * widget )
{
	if ( widget != 0 )
	{
		if ( widget->isMinimized() )
		{
			widget->setEnabled(true);
			widget->showNormal();
		}
		else if ( widget->isVisible() )
		{
			if ( pWorkspace->activeWindow() == widget )
			{
				widget->setEnabled(false);
				widget->hide();
			}
			else
			{
				widget->setEnabled(true);
				widget->setFocus();
			}
		}
		else if ( widget->isMaximized() )
		{
			widget->setEnabled(true);
			widget->showMaximized();
		}
		else
		{
			widget->setEnabled(true);
			widget->show();
		}
	}
}

/** show/hide server list window */
void DCGuiApp::slotActionServerList()
{
	statusBar()->message(tr("Show/hide hub list window ..."));

	showMDIWidget(g_pHubListManager);

	statusBar()->message(tr("Ready."));
}

/** show/hide multi hub search window */
void DCGuiApp::slotActionHubSearch()
{
	statusBar()->message(tr("Open hub search window ..."));

	DCHubSearch * hubsearch = new DCHubSearch( pWorkspace );
	hubsearch->show();

	statusBar()->message(tr("Ready."));
}

/** show/hide spy window */
void DCGuiApp::slotActionSpy()
{
	statusBar()->message(tr("Show/hide spy window ..."));

	showMDIWidget(g_pSpy);

	statusBar()->message(tr("Ready."));
}

/** show/hide users window */
void DCGuiApp::slotActionUsers()
{
	statusBar()->message(tr("Show/hide users window ..."));

	showMDIWidget(g_pUsersList);

	statusBar()->message(tr("Ready."));
}

/** show the tray menu icon */
void DCGuiApp::slotTrayMenu( const QPoint&, int i )
{
	int id;
	int remove;
	int dock;

	QPopupMenu *m;

	if ( i == RightButton )
	{
		m = new QPopupMenu(this);

		DCMenuHandler::InsertMenu( m, emiUSER_CAPTION, false, "Valknut" );
		DCMenuHandler::InsertMenu( m, emiSEPARATOR );
		dock = m->insertItem( tr("Dock/Undock") );
		remove = m->insertItem( tr("Remove tray icon") );
		DCMenuHandler::InsertMenu( m, emiEXIT );

		id = m->exec(QCursor::pos());

		delete m;

		if ( id == emiEXIT )
		{
			slotFileQuit();
		}
		else if ( id == dock )
		{
			slotViewDock();
		}
		else if ( id == remove )
		{
			slotRemoveTrayIcon();
		}
	}
	else
	{
		slotViewDock();
	}
}

/** */
void DCGuiApp::slotRemoveTrayIcon()
{
	if ( m_bTray )
	{
		slotViewDock();
	}
	
	// deinitTray() is called in slotTimeout()
	m_bEnableTray = false;
	
	viewDock->setEnabled(false);
	g_pConfig->SetEnableTray(false);
}

/** */
void DCGuiApp::SetTheme()
{
	if ( g_pConfig->GetThemeSupport() )
	{
		QString s = g_pConfig->GetTheme();

		if ( s.isEmpty() )
		{
			printf("Can't set empty theme\n");
		}
		else
		{
			QApplication::setStyle( s );
		}
	}
}

/** */
void DCGuiApp::slotDefaultDownloadModeChanged()
{
	switch (g_pConfig->GetDefaultDownloadMode())
	{
		case 0: fileDefaultDldAsk->setOn(true); break;
		case 1: fileDefaultDldSingle->setOn(true); break;
		case 2: fileDefaultDldMulti->setOn(true); break;
		default: break;
	}
}

/** */
void DCGuiApp::slotViewTrayIcon( bool toggle )
{
	g_pConfig->SetEnableTray( toggle );
	
	if ( toggle )
	{
		initTray();
	}
	else
	{
		deinitTray();
	}
	
	viewDock->setEnabled( toggle );
}

/** */
void DCGuiApp::closeWindowsOfClass( QString classname )
{
	QWidgetList windows = pWorkspace->windowList( QWorkspace::CreationOrder );
	
	for ( unsigned int i = 0; i < windows.count(); ++i )
	{
		if ( windows.at(i)->isA(classname.ascii()) )
		{
			windows.at(i)->close();
		}
	}
}

/** */
void DCGuiApp::slotDebugSettings()
{
	DCDialogDebugSettings * dialog = new DCDialogDebugSettings(this);
	dialog->ComboBox_PRINTF->setCurrentItem(dclibVerbose());
	dialog->ComboBox_SOCKETLOG->setCurrentItem(CSocket::m_eSocketLog);
	
	if ( dialog->exec() == QDialog::Accepted )
	{
		setdclibVerbose( dialog->ComboBox_PRINTF->currentItem() );
		switch ( dialog->ComboBox_SOCKETLOG->currentItem() )
		{
			case 0:
				CSocket::m_eSocketLog = eslNONE;
				break;
			case 1:
				CSocket::m_eSocketLog = eslSEND;
				break;
			case 2:
				CSocket::m_eSocketLog = eslRECV;
				break;
			case 3:
				CSocket::m_eSocketLog = eslBOTH;
				break;
			default:
				CSocket::m_eSocketLog = eslNONE;
				break;
		}
	}
	
	delete dialog;
}

/** */
void DCGuiApp::slotContextMenuTraffic()
{
	QPopupMenu * m = new QPopupMenu(this);
	
	DCMenuHandler::InsertMenu( m, emiRESET );
	
	const int id = m->exec(QCursor::pos());
	
	delete m;
	
	if ( id == emiRESET )
	{
		CSocket::m_Traffic.ResetTraffic();
		g_pConfig->ResetSessionStats();
		statusTRLabel->clear();
	}
}
