/***************************************************************************
                          dcgui.h  -  description
                             -------------------
    begin                : Mon Okt  1 19:59:45 CEST 2001
    copyright            : (C) 2001-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCGUI_H
#define DCGUI_H

// include files for QT
#include <qmainwindow.h>
#include <qstring.h>

#include "dcapplicationevents.h"

// forward declaration of the DCGui classes
class QDockWindow;
class QTimer;
class TrayIcon;
class QAction;
class QActionGroup;
class QToolBar;
class QWorkspace;
class QPopupMenu;
class QLabel;
class DCQLabel;
class QEvent;
class QCloseEvent;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class DCGuiView is
  * created which creates your view.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.3 code generation
  */
class DCGuiApp : public QMainWindow
{
Q_OBJECT

public:
	/** construtor */
	DCGuiApp();
	/** destructor */
	virtual ~DCGuiApp();

	/** */
	void ShowOptionsDialog() { slotFileOptions(); };
	/** setup all windows */
	void initWindows();
	/** */
	void Dock() { slotViewDock(); };

protected:
	/** overloaded for Message box on last window exit */
	bool queryExit();
	/** handle close event prompting for quit */
	virtual void closeEvent( QCloseEvent * event );
	/** Receive custom events for updating status bars */
	virtual void customEvent( QCustomEvent * event );

private slots:

	/** */
	void slotFileOptions();
	/** */
	void slotFileQuickOptions();
	/** */
	void slotFileFileListBrowser();
	/** */
	void slotFileFileListBrowserLocal();
	/** */
	void slotFileCreateShare();
	/** */
	void slotFileReloadPlugins();
	/** change default download mode */
	void slotChangeDefaultDldMode(QAction* DldType);
	/** exits the application */
	bool slotFileQuit();

	/** toggle the tabbar*/
	void slotViewTabBar(bool toggle);
	/** toggle the toolbar*/
	void slotViewToolBar(bool toggle);
	/** toggle the statusbar*/
	void slotViewStatusBar(bool toggle);
	/** show or hide the system tray icon */
	void slotViewTrayIcon(bool toggle);
	/** dock the application */
	void slotViewDock();
	/** shows an about dlg*/
	void slotHelpAbout();
	/** opens the online manual in web browser */
	void slotHelpManual();
	/** connect to the valknut hub */
	void slotHelpSupport();
	/** gets called when the window menu is activated; recreates the window menu with all opened window titles. */
	void windowMenuAboutToShow();
	/** activates the MDI child widget when it gets selected from the window menu. */
	void windowMenuActivated( int id );

	/** show/hide transfer list window */
	void slotActionTransferList();
	/** show/hide server list window */
	void slotActionServerList();
	/** show/hide hub search window */
	void slotActionHubSearch();
	/** show/hide spy window */
	void slotActionSpy();
	/** show/hide users window */
	void slotActionUsers();
	/** change user away mode */
	void slotChangeAwayMode();

	/** */
	void tileVertically();
	/** minimize all windows */
	void slotWindowMinimize();
	/** close all disconnected hub windows */
	void slotWindowCloseHubs();
	/** */
	void slotWindowCloseAllChats();
	/** */
	void slotWindowCloseOfflineChats();
	/** */
	void slotWindowCloseFilelists();
	/** */
	void slotWindowCloseSearches();

	/** */
	void slotTimeout();
	/** show the tray menu icon */
	void slotTrayMenu( const QPoint&, int );
	/** remove an existing tray icon */
	void slotRemoveTrayIcon();

	/** set quick options menu to match setting */
	void slotDefaultDownloadModeChanged();

	/** show debug settings dialog */
	void slotDebugSettings();
	
	/** context menu to reset traffic stats */
	void slotContextMenuTraffic();

private:
	/** */
	void SetTheme();

	/** initializes all QActions of the application */
	void initActions();
	/** deinitializes all QActions of the application */
	void deinitActions();
	/** initMenuBar creates the menu_bar and inserts the menuitems */
	void initMenuBar();
	/** this creates the toolbars. Change the toobar look and add new toolbars in this
	  * function */
	void initToolBar();
	/** setup the statusbar */
	void initStatusBar();
	/** initialize the mainview*/
	void initView();
	/** deinitialize the mainview*/
	void deinitView();
	/** initialize the tray icon */
	void initTray();
	/** deinitialize the tray icon */
	void deinitTray();
	/** show/hide mdi widget */
	void showMDIWidget( QWidget * widget );
	/** */
	void showFreeDiscSpace();
	/** */
	void closeWindowsOfClass( QString classname );
	
	/** file_menu contains all items of the menubar entry "File" */
	QPopupMenu *pFileMenu;
	/** */
	QPopupMenu *pQuickOptionsMenu;
	/** */
	QPopupMenu *pReloadPluginsMenu;
	/** view_menu contains all items of the menubar entry "View" */
	QPopupMenu *pViewMenu;
	/** view_menu contains all items of the menubar entry "Help" */
	QPopupMenu *pHelpMenu;
	/** the window menu */
	QPopupMenu *pWindowMenu;

	/** action */
	QPopupMenu *pActionMenu;
	/** away mode */
	QPopupMenu *pAwayMenu;
	/** */
	QToolBar *windowsTabBar;
	/** */
	QToolBar *fileToolbar;
	/** */
	QLabel * statusDMLabel;
	/** */
	QLabel * statusFMLabel;
	/** */
	DCQLabel * statusTRLabel;
	/** */
	QLabel * statusDSLabel;
	/** */
	QWorkspace *pWorkspace;
	/** */
	QAction *fileOptions;
	/** */
	QAction *fileQuickOptions;
	/** */
	QAction *fileFileListBrowser;
	/** */
	QAction *fileFileListBrowserLocal;
	/** */
	QAction *fileFileListRefresh;
	/** */
	QAction *fileReloadPlugins;
	/** */
	QAction *fileQuit;
	/** */
	QActionGroup *fileDefaultDldGroup;
	/** */
	QAction *fileDefaultDldAsk;
	/** */
	QAction *fileDefaultDldSingle;
	/** */
	QAction *fileDefaultDldMulti;
	/** */
	QAction *viewTabBar;
	/** */
	QAction *viewToolBar;
	/** */
	QAction *viewStatusBar;
	/** */
	QAction *viewDock;
	/** */
	QAction *viewTrayIcon;
	/** */
	QAction *windowTile;
	/** */
	QAction *windowTileHor;
	/** */
	QAction *windowCascade;
	/** */
	QAction *windowMinimize;
	/** */
	QAction *windowCloseHubs;
	/** */
	QAction *windowCloseAllChats;
	/** */
	QAction *windowCloseOfflineChats;
	/** */
	QAction *windowCloseFilelists;
	/** */
	QAction *windowCloseSearches;
	/** */
	QActionGroup *windowAction;
	/** */
	QAction *actionServerList;
	/** */
	QAction *actionTransferList;
	/** */
	QAction *actionHubSearch;
	/** */
	QAction *actionSpy;
	/** */
	QAction *actionUsers;
	/** */
	QActionGroup * actionGroupAwayMode;
	/** */
	QAction *actionAwayModeNormal;
	/** */
	QAction *actionAwayModeAway;
	/** */
	QAction *helpAboutApp;
	/** */
	QAction *helpManualApp;
	/** */
	QAction *helpSupportApp;
	/** */
	QAction *debugSettings;
	/** */
	QDockWindow * pTransferViewDock;
	/** */
	QTimer * m_pTimer;
	/** */
	DCApplicationEvents m_ApplicationEvents;
	/** tray icon */
	TrayIcon * m_pTrayIcon;
	/** */
	bool m_bTray;
	/** */
	bool m_bEnableTray;
	/**
	 * Set to true if the transfer view was floating when valknut got
	 * minimized to tray. In QT3 it is only needed for the
	 * start in tray icon option.
	 */
	bool m_bTransferViewGotTrayed;
	/** hold old desktop position on dock/undock */
	QPoint m_DesktopPosition;
	/** hold old maximized status on dock/undock */
	bool m_bWasMaximized;
	/** */
	bool m_bIsQuitPromptVisible;
};
#endif
