/***************************************************************************
                dcguiutils.cpp  -  Valknut Utility Functions
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcguiutils.h"

#include <dclib/core/cstring.h>
#include <dclib/cutils.h>

#include <qcombobox.h>
#include <qlistview.h>

#include "dcconfig.h"

/* theme detection */
#include <qapplication.h>
#include <qstyle.h>
#include <qstylefactory.h>
#include <qstringlist.h>

/** */
DCGuiUtils::DCGuiUtils()
{
	// nothing
}

/** */
DCGuiUtils::~DCGuiUtils()
{
	// nothing
}

/** */
QString DCGuiUtils::GetSizeString( const ulonglong size )
{
	/* could check if g_pConfig is null and use default, but not really worth it */
	return QString::fromAscii( CUtils::GetSizeString( size, g_pConfig->GetUnit() ).Data() );
}

/** */
void DCGuiUtils::AddEncodings( QComboBox * combobox )
{
	combobox->insertItem("UTF-8");
	combobox->insertItem("WINDOWS-1252");
	combobox->insertItem("WINDOWS-1251");
	combobox->insertItem("WINDOWS-1250");
	combobox->insertItem("WINDOWS-1256");
	combobox->insertItem("WINDOWS-1257");
	combobox->insertItem("ISO-8859-1");
	combobox->insertItem("ISO-8859-2");
	combobox->insertItem("ISO-8859-7");
	combobox->insertItem("ISO-8859-8");
	combobox->insertItem("ISO-8859-9");
	combobox->insertItem("ISO-2022-JP");
	combobox->insertItem("SHIFT-JIS");
	combobox->insertItem("CP949");
	combobox->insertItem("KOI8-R");
	combobox->insertItem("GB18030");
	combobox->insertItem("TIS-620");
}

/** */
QString DCGuiUtils::SortOrderName( const Qt::SortOrder order )
{
	if ( order == Qt::Descending )
	{
		return QString::fromAscii("Descending");
	}
	else
	{
		return QString::fromAscii("Ascending");
	}
}

/** */
Qt::SortOrder DCGuiUtils::SortOrderFromName( const QString name )
{
	if ( name == "Descending" )
	{
		return Qt::Descending;
	}
	else
	{
		return Qt::Ascending;
	}
}

/** */
int DCGuiUtils::FindRowForItem( QListView * view, QListViewItem * item )
{
	if ( !view || !item )
	{
		return -1;
	}
	
	int i = 0;
	
	QListViewItemIterator it( view );
	
	while ( it.current() )
	{
		if ( it.current() == item )
		{
			return i;
		}
		
		++i;
		++it;
	}
	
	return -1;
}

/** */
void DCGuiUtils::AdjustColumnWidths( QListView * view, int oldsize )
{
	bool updates = view->isUpdatesEnabled();
	if ( updates )
	{
		view->setUpdatesEnabled(false);
	}
	
	// need floats to reduce rounding errors
	float newwidth = (float) view->width();
	float oldsize_f = (float) oldsize;
	
	int newcolwidth;
	for ( int i = 0; i < view->columns(); i++ )
	{
		newcolwidth = (int) ( ((float) view->columnWidth(i)) * newwidth / oldsize_f );
		if ( newcolwidth < 10 )
		{
			newcolwidth = 10;
		}
		
		view->setColumnWidth( i, newcolwidth );
	}
	
	if ( updates )
	{
		view->setUpdatesEnabled(true);
	}
}

/** */
int DCGuiUtils::SelectedItems( QListView * view, QPtrList<QListViewItem> & list )
{
	QListViewItemIterator it( view );

	for ( ; it.current(); ++it )
	{
		if ( it.current()->isSelected() )
		{
			list.append(it.current());
		}
	}

	return list.count();
}

/** */
QString DCGuiUtils::DetectAppStyleKey()
{
	QString key;
	
	QString appstylekey = QApplication::style().className();
	
	QStringList keys = QStyleFactory::keys();
	
	for ( QStringList::const_iterator it = keys.constBegin(); it != keys.constEnd(); ++it )
	{
		QStyle * temp = QStyleFactory::create( *it );
		if ( temp )
		{
			QString tempclass = temp->className();
			delete temp;
			
			if ( tempclass == appstylekey )
			{
				key = *it;
				break;
			}
		}
	}
	
	return key;
}
