/***************************************************************************
   dchublistitems.cpp  -  Items used by DCHubListManager - Implementation
                             -------------------
    begin                : Wed Jul 3 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dchublistitems.h"

#include "dcguiutils.h"

/** */
void DCPublicHubListItem::SetUsers( const ulonglong u )
{
	users = u;
	QListViewItem::setText( 3, text(3) );
}

/** */
void DCPublicHubListItem::SetShared( const ulonglong s )
{
	shared = s;
	QListViewItem::setText( 5, text(5) );
}

/** */
void DCPublicHubListItem::SetMinShare( const ulonglong m )
{
	minshare = m;
	QListViewItem::setText( 6, text(6) );
}

/** */
void DCPublicHubListItem::setText( int col, const QString & text )
{
	/* Better to use SetUsers SetShared or SetMinShare instead */
	if ( col == 3 )
	{
		bool ok = false;
		ulonglong u = text.toULongLong( &ok );
		if ( ok )
		{
			users = u;
			QListViewItem::setText( 3, text );
		}
	}
	else if ( col == 5 )
	{
		bool ok = false;
		ulonglong s = text.toULongLong( &ok );
		if ( ok )
		{
			shared = s;
			QListViewItem::setText( 5, text );
		}
	}
	else if ( col == 6 )
	{
		bool ok = false;
		ulonglong m = text.toULongLong( &ok );
		if ( ok )
		{
			minshare = m;
			QListViewItem::setText( 6, text );
		}
	}
	else
	{
		QListViewItem::setText( col, text );
	}
}

/** */
QString DCPublicHubListItem::text( int col ) const
{
	if ( col == 3 )
	{
		return QString().setNum(users);
	}
	else if ( col == 5 )
	{
		return DCGuiUtils::GetSizeString(shared);
	}
	else if ( col == 6 )
	{
		return DCGuiUtils::GetSizeString(minshare);
	}
	else
	{
		return QListViewItem::text( col );
	}
}

/** */
int DCPublicHubListItem::compare( QListViewItem * item, int col, bool ascending ) const
{
	DCPublicHubListItem* dcitem = 0;
	if ( item->rtti() == rtti() )
	{
		dcitem = (DCPublicHubListItem*)item;
	}
	else
	{
		//printf("DCPublicHubListItem::compare: other item is not a DCPublicHubListItem rtti=%d\n",item->rtti());
		return QListViewItem::compare( item, col, ascending );
	}
	
	if ( col == 3 )
	{
		if ( users < dcitem->users )
		{
			return -1;
		}
		else if ( users == dcitem->users )
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}
	else if ( col == 5 )
	{
		if ( shared < dcitem->shared )
		{
			return -1;
		}
		else if ( shared == dcitem->shared )
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}
	else if ( col == 6 )
	{
		if ( minshare < dcitem->minshare )
		{
			return -1;
		}
		else if ( minshare == dcitem->minshare )
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}
	else
	{
		return QListViewItem::compare( item, col, ascending );
	}
}

/** Actaully this should not get used because compare() is overridden. */
QString DCPublicHubListItem::key( int col, bool ascending ) const
{
	if ( col == 3 )
	{
		return QString().setNum(users).rightJustify(20,'0');
	}
	else if ( col == 5 )
	{
		return QString().setNum(shared).rightJustify(30,'0');
	}
	else if ( col == 6 )
	{
		return QString().setNum(minshare).rightJustify(30,'0');
	}
	else
	{
		return QListViewItem::key( col, ascending );
	}
}
