/***************************************************************************
        dchublistitems.h  -  Items used by DCHubListManager - Header
                             -------------------
    begin                : Wed Jul 3 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCHUBLISTITEMS_H
#define DCHUBLISTITEMS_H

/**
  * @author Edward Sheldrake
  *
  * Modified QListViewItems used by DCHubListManager.
  */

#include <qlistview.h>

// for ulonglong
#include <dclib/dcos.h>

class DCBookmarkHubItem : public QListViewItem {

public:
	/** constructor */
	DCBookmarkHubItem( QListView * parent ) : QListViewItem( parent ) { };
	/** constructor */
	DCBookmarkHubItem( QListViewItem * parent ) : QListViewItem( parent ) { };
	/** destructor */
	virtual ~DCBookmarkHubItem() { };
	
	/**
	 * It's really the key of the item in CConfig's ordered bookmark map, which may or
	 * may not be the actual position of the item in the QListView.
	 */
	int position;
};

class DCPublicHubListItem : public QListViewItem {

public:
	/** constructor */
	DCPublicHubListItem( QListView * parent ) : QListViewItem(parent) {
		users = 0;
		shared = 0;
		minshare = 0;
	} ;
	/** constructor */
	DCPublicHubListItem( QListViewItem * parent ) : QListViewItem(parent) {
		users = 0;
		shared = 0;
		minshare = 0;
	} ;
	/** destructor */
	virtual ~DCPublicHubListItem() {};
	
	/** */
	virtual void setText( int column, const QString & text );
	/** */
	virtual QString text( int column ) const;
	/** */
	virtual int compare( QListViewItem * item, int col, bool ascending ) const;
	/** */
	virtual QString key( int column, bool ascending ) const;
	/** */
	virtual int rtti() const { return 2000; };

	/** */
	void SetUsers( const ulonglong u );
	/** */
	void SetShared( const ulonglong s );
	/** */
	void SetMinShare( const ulonglong m );

private:
	/** users */
	ulonglong users;
	/** total shared in bytes */
	ulonglong shared;
	/** minimum share in bytes */
	ulonglong minshare;
};

#endif // DCHUBLISTITEMS_H
