/***************************************************************************
                          dchublistmanager.h  -  description
                             -------------------
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCHUBLISTMANAGER_H
#define DCHUBLISTMANAGER_H

/**
  *@author Mathias Küster
  */

#include <qtimer.h>
#include <qmap.h>
#include <qmutex.h>
#include <qptrqueue.h>

#include "DCDialogHubListManager.h"

#include <dclib/chublistmanager.h>

class QListViewItem;
class DC_HubFilterObject;

/* filtered hub list for search dialog not yet re-written */
#include <dclib/core/cstringlist.h>

class DCHubListManager : public DCDialogHubListManager, public CHubListManager {
Q_OBJECT

public:
	/** construtor */
	DCHubListManager(QWidget* parent, const char *name);
	/** destructor */
	virtual ~DCHubListManager();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();
	/** */
	void ShowPublicHubList();
	/** */
	void ShowBookmarkList();
	/** */
	void AddBookmark( QString hubname, QString hubhost, QString description );
	/** */
	void RemoveBookmark( QListViewItem * item );
	/** */
	void UpdateBookmark( QString hubname, QString hubhost, QString description );
	/** */
	CStringList<CString> * GetFilteredHubList();

	/** overridden so that the column widths are initialized on first show() */
	virtual void show();

	/** callback function */
	virtual int DC_CallBack( CDCMessage * );

protected:
	/** Adjust column sizes preserving user set size ratios */
	void SizeColumnsPreservingRatios();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private:
	/** */
	void SetToolBar( QFrame * frame1, QFrame * frame2, bool vis ); 
	/**
	 * Update CConfig with the new sorted order of the bookmarks.
	 */
	void updateBookmarkOrder();

	/** */
	QMutex m_HLMMutex;
	/** */
	QMap<QString, DC_HubFilterObject*> m_HubFilterMap;
	/** */
	QTimer m_Timer;
	/** */
	QPtrQueue<CDCMessage> * m_pMessageQueue;
	/** */
	int bookmarksLastSortColumn;
	/** */
	Qt::SortOrder bookmarksLastSortOrder;
	/** The last width that we adjusted the size of the public hubs columns for */
	int lastPublicHubsWidth;
	/** The last width that we adjusted the size of the bookmark hubs columns for */
	int lastBookmarkHubsWidth;

private slots:
	/** reload public hub list */
	void slotReloadPublicHubList();
	/** update public hub list */
	void slotUpdatePublicHubList();
	/** */
	void slotDoubleClicked( QListViewItem * item, const QPoint &, int );
	/** */
	void slotReturnPressed( QListViewItem * item );
	/** */
	void slotConnect();
	/** */
	void slotRightButtonClickedPublicList( QListViewItem *, const QPoint &, int );
	/** */
	void slotRightButtonClickedBookmarkList( QListViewItem *, const QPoint &, int );
	/** current tab widget change slot */
	void slotTabWidgetCurrentChange( QWidget * );
	/** */
	void slotAddFilter();
	/** */
	void slotEditFilter();
	/** */
	void slotDelFilter();
	/** */
	void slotFilterChange( const QString & );
	/** */
	void timerDone();
	/** */
	void slotMoveBookmarkUp();
	/** */
	void slotMoveBookmarkDown();
	/** */
	void slotEnableBookmarkSorting();
	/** */
	void slotSaveBookmarks();
};

/** */
extern DCHubListManager * g_pHubListManager;

#endif
